/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.Objects;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.HexStringAttributeType;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpCollectionSetToCollectionSetDTOConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollectionSetToCollectionSetDTOConverter.class);
    private ServiceParameters params;

    public SnmpCollectionSetToCollectionSetDTOConverter withParameters(ServiceParameters params) {
        this.params = params;
        return this;
    }

    public CollectionSetDTO convert(SnmpCollectionSet collectionSet) {
        Objects.requireNonNull(collectionSet, "SnmpCollectionSet cannot be null");
        Objects.requireNonNull(this.params, "ServiceParameters cannot be null");
        CollectionSetBuilder builder = new CollectionSetBuilder((CollectionAgent)collectionSet.getAgent());
        builder.withTimestamp(collectionSet.getCollectionTimestamp());
        for (CollectionResource collectionResource : collectionSet.getResources()) {
            this.addResourceToBuilder(builder, collectionResource);
        }
        return builder.build();
    }

    public void addResourceToBuilder(CollectionSetBuilder builder, CollectionResource collectionResource) {
        NodeLevelResource builderResource;
        SnmpCollectionResource snmpResource = (SnmpCollectionResource)collectionResource;
        if (collectionResource instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)collectionResource;
            builderResource = new NodeLevelResource(nodeInfo.getNodeId());
        } else if (collectionResource instanceof IfInfo) {
            IfInfo ifInfo = (IfInfo)collectionResource;
            builderResource = new InterfaceLevelResource(new NodeLevelResource(ifInfo.getNodeId()), ifInfo.getAttributesMap().get("snmpifname"));
        } else if (collectionResource instanceof GenericIndexResource) {
            GenericIndexResource genericResource = (GenericIndexResource)collectionResource;
            ResourceType resourceType = ((GenericIndexResourceType)genericResource.getResourceType()).getResourceType();
            builderResource = new GenericTypeResource(new NodeLevelResource(genericResource.getCollectionAgent().getNodeId()), (org.opennms.netmgt.collection.api.ResourceType)resourceType, genericResource.getInstance());
        } else {
            LOG.warn("we don't support {}, will ignore it", (Object)collectionResource.getClass().getName());
            return;
        }
        Collection<AttributeGroup> groups = snmpResource.getGroups();
        if (collectionResource.shouldPersist(this.params)) {
            this.addGroupsToBuilder(builder, (Resource)builderResource, groups);
        }
    }

    private void addGroupsToBuilder(CollectionSetBuilder builder, Resource resource, Collection<AttributeGroup> groups) {
        for (AttributeGroup group : groups) {
            if (!group.shouldPersist(this.params)) continue;
            this.addGroupToBuilder(builder, resource, group);
        }
    }

    private void addGroupToBuilder(CollectionSetBuilder builder, Resource resource, AttributeGroup group) {
        for (CollectionAttribute attribute : group.getAttributes()) {
            if (!attribute.shouldPersist(this.params)) continue;
            String value = attribute.getAttributeType() instanceof HexStringAttributeType ? ((SnmpAttribute)attribute).getValue().toHexString() : attribute.getStringValue();
            builder.withAttribute(resource, group.getName(), attribute.getName(), value, attribute.getType());
        }
    }
}

