/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.tcp;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.opennms.netmgt.collection.api.ByNameComparator;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.persistence.tcp.TcpOutputStrategy;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.slf4j.LoggerFactory;

public class TcpPersistOperationBuilder
implements PersistOperationBuilder {
    final String baseDir = System.getProperty("rrd.base.dir", "");
    final String fileExt = System.getProperty("org.opennms.rrd.fileExtension", "");
    private final TcpOutputStrategy m_tcpStrategy;
    private final String m_rrdName;
    private final ResourceIdentifier m_resource;
    private final Map<CollectionAttributeType, Number> m_dbl_declarations = new TreeMap<CollectionAttributeType, Number>((Comparator<CollectionAttributeType>)new ByNameComparator());
    private final Map<String, String> m_str_declarations = new TreeMap<String, String>();
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();

    public TcpPersistOperationBuilder(TcpOutputStrategy tcpStrategy, ResourceIdentifier resource, String rrdName) {
        this.m_tcpStrategy = Objects.requireNonNull(tcpStrategy);
        this.m_resource = Objects.requireNonNull(resource);
        this.m_rrdName = Objects.requireNonNull(rrdName);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    private File getResourceDir(ResourceIdentifier resource) throws FileNotFoundException {
        return new File(this.baseDir).toPath().resolve(ResourcePath.resourceToFilesystemPath((ResourcePath)resource.getPath())).toFile();
    }

    public void setAttributeValue(CollectionAttributeType attributeType, Number value) {
        this.m_dbl_declarations.put(attributeType, value);
    }

    public void setStringAttributeValue(String key, String value) {
        this.m_str_declarations.put(key, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
    }

    public void commit() throws PersistException {
        if (this.m_dbl_declarations.size() == 0 && this.m_str_declarations.size() == 0) {
            return;
        }
        try {
            String ownerName = this.m_resource.getOwnerName();
            String absolutePath = this.getResourceDir(this.m_resource).getAbsolutePath();
            String rrdFile = absolutePath + File.separator + this.m_rrdName + this.fileExt;
            long timestamp = this.m_timeKeeper.getCurrentTime();
            long time = (timestamp + 500L) / 1000L;
            this.m_tcpStrategy.updateData(rrdFile, ownerName, new Long(time), this.getDblValues(), this.getStrValues());
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get resource directory: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new PersistException((Throwable)e);
        }
    }

    private List<Double> getDblValues() {
        return this.m_dbl_declarations.values().stream().map(v -> v.doubleValue()).collect(Collectors.toList());
    }

    private List<String> getStrValues() {
        return this.m_str_declarations.values().stream().collect(Collectors.toList());
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }
}

