/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.tcp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.collection.persistence.tcp.SimpleTcpOutputStrategy;
import org.opennms.netmgt.collection.persistence.tcp.TcpOutputStrategy;
import org.opennms.netmgt.rrd.tcp.RrdOutputSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuingTcpOutputStrategy
implements TcpOutputStrategy {
    private static final long SLEEP_TIME = Long.getLong("org.opennms.netmgt.persistence.tcp.queuingTcpSleepTime", 1000L);
    private static final long OFFER_WAIT_TIME = Long.getLong("org.opennms.netmgt.persistence.tcp.queuingTcpOfferWaitTime", 500L);
    private static final Logger LOG = LoggerFactory.getLogger(QueuingTcpOutputStrategy.class);
    private final BlockingQueue<PerformanceDataReading> m_queue;
    private int m_skippedReadings = 0;

    public QueuingTcpOutputStrategy(SimpleTcpOutputStrategy delegate, int queueSize) {
        this.m_queue = new LinkedBlockingQueue<PerformanceDataReading>(queueSize);
        ConsumerThread consumerThread = new ConsumerThread(delegate, this.m_queue);
        consumerThread.start();
    }

    @Override
    public void updateData(String path, String owner, Long timestamp, List<Double> dblValues, List<String> strValues) throws Exception {
        if (this.m_queue.offer(new PerformanceDataReading(path, owner, timestamp, dblValues, strValues), OFFER_WAIT_TIME, TimeUnit.MILLISECONDS)) {
            if (this.m_skippedReadings > 0) {
                LOG.warn("Skipped {} performance data message(s) because of queue overflow", (Object)this.m_skippedReadings);
                this.m_skippedReadings = 0;
            }
        } else {
            ++this.m_skippedReadings;
        }
    }

    private static class ConsumerThread
    extends Thread {
        private final BlockingQueue<PerformanceDataReading> m_myQueue;
        private final SimpleTcpOutputStrategy m_strategy;

        public ConsumerThread(SimpleTcpOutputStrategy strategy, BlockingQueue<PerformanceDataReading> queue) {
            this.m_strategy = strategy;
            this.m_myQueue = queue;
            this.setName(this.getClass().getSimpleName());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ArrayList sendMe;
                    if (this.m_myQueue.drainTo(sendMe = new ArrayList()) > 0) {
                        RrdOutputSocket socket = new RrdOutputSocket(this.m_strategy.getHost(), this.m_strategy.getPort());
                        for (PerformanceDataReading reading : sendMe) {
                            socket.addData(reading.getFilename(), reading.getOwner(), reading.getTimestamp(), reading.getDblValues(), reading.getStrValues());
                        }
                        socket.writeData();
                        continue;
                    }
                    Thread.sleep(SLEEP_TIME);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException caught in QueuingTcpOutputStrategy$ConsumerThread, closing thread");
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception caught in QueuingTcpOutputStrategy$ConsumerThread, closing thread", e);
            }
        }
    }

    private static class PerformanceDataReading {
        private String m_filename;
        private String m_owner;
        private Long m_timestamp;
        private List<Double> m_dblValues;
        private List<String> m_strValues;

        public PerformanceDataReading(String filename, String owner, Long timestamp, List<Double> dblValues, List<String> strValues) {
            this.m_filename = filename;
            this.m_owner = owner;
            this.m_timestamp = timestamp;
            this.m_dblValues = dblValues;
            this.m_strValues = strValues;
        }

        public String getFilename() {
            return this.m_filename;
        }

        public String getOwner() {
            return this.m_owner;
        }

        public Long getTimestamp() {
            return this.m_timestamp;
        }

        public List<Double> getDblValues() {
            return this.m_dblValues;
        }

        public List<String> getStrValues() {
            return this.m_strValues;
        }
    }
}

