/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.util.Set;
import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersistOperationBuilder;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePersister
extends AbstractPersister {
    protected static final Logger LOG = LoggerFactory.getLogger(BasePersister.class);
    private final RrdStrategy<?, ?> m_rrdStrategy;
    private final ResourceStorageDao m_resourceStorageDao;
    private boolean m_dontReorderAttributes = false;

    protected BasePersister(ServiceParameters params, RrdRepository repository, RrdStrategy<?, ?> rrdStrategy, ResourceStorageDao resourceStorageDao) {
        super(params, repository);
        this.m_rrdStrategy = rrdStrategy;
        this.m_resourceStorageDao = resourceStorageDao;
    }

    protected RrdPersistOperationBuilder createBuilder(CollectionResource resource, String name, Set<CollectionAttributeType> attributeTypes) {
        RrdPersistOperationBuilder builder = new RrdPersistOperationBuilder(this.getRrdStrategy(), this.getRepository(), (ResourceIdentifier)resource, name, this.m_dontReorderAttributes);
        if (resource.getTimeKeeper() != null) {
            builder.setTimeKeeper(resource.getTimeKeeper());
        }
        for (CollectionAttributeType attrType : attributeTypes) {
            if (!(attrType instanceof NumericCollectionAttributeType)) continue;
            builder.declareAttribute(attrType);
        }
        return builder;
    }

    protected void setBuilder(RrdPersistOperationBuilder builder) {
        super.setBuilder((PersistOperationBuilder)builder);
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) throws PersistException {
        try {
            this.m_resourceStorageDao.setStringAttribute(path, key, value);
        }
        catch (Throwable t) {
            throw new PersistException(t);
        }
    }

    public RrdStrategy<?, ?> getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public void setDontReorderAttributes(boolean dontReorderAttributes) {
        this.m_dontReorderAttributes = dontReorderAttributes;
    }

    public boolean getDontReorderAttributes() {
        return this.m_dontReorderAttributes;
    }
}

