/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.commands;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.commands.CollectorClassNameCompleter;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.snmp.InetAddrUtils;

@Command(scope="collection", name="collect", description="Invokes a collector against a host at a specified location.")
@Service
public class CollectCommand
implements Action {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String systemId;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live in milliseconds", required=false, multiValued=false)
    Long ttlInMs;
    @Option(name="-n", aliases={"--node"}, description="Node ID or FS:FID", required=false, multiValued=false)
    String nodeCriteria;
    @Argument(index=0, name="collectorClass", description="Collector class", required=true, multiValued=false)
    @Completion(value=CollectorClassNameCompleter.class)
    String className;
    @Argument(index=1, name="host", description="Hostname or IP Address of the system to poll", required=true, multiValued=false)
    String host;
    @Argument(index=2, name="attributes", description="Collector specific attributes in key=value form", multiValued=true)
    List<String> attributes;
    @Reference
    public ServiceCollectorRegistry serviceCollectorRegistry;
    @Reference
    public LocationAwareCollectorClient locationAwareCollectorClient;
    @Reference
    public CollectionAgentFactory collectionAgentFactory;

    public Void execute() {
        ServiceCollector collector = this.serviceCollectorRegistry.getCollectorByClassName(this.className);
        if (collector == null) {
            System.out.printf("No collector found with class name '%s'. Aborting.\n", this.className);
            return null;
        }
        try {
            collector.initialize();
        }
        catch (CollectionInitializationException e) {
            System.out.println("Failed to initialize the collector. Aborting.");
            e.printStackTrace();
            return null;
        }
        CollectionAgent agent = this.getCollectionAgent();
        CompletableFuture future = this.locationAwareCollectorClient.collect().withAgent(agent).withSystemId(this.systemId).withCollector(collector).withTimeToLive(this.ttlInMs).withAttributes(CollectCommand.parse(this.attributes)).execute();
        while (true) {
            try {
                try {
                    CollectionSet collectionSet = (CollectionSet)future.get(1L, TimeUnit.SECONDS);
                    if (CollectionStatus.SUCCEEDED.equals((Object)collectionSet.getStatus())) {
                        CollectCommand.printCollectionSet(collectionSet);
                        break;
                    }
                    System.out.printf("\nThe collector returned a collection set with status: %s\n", collectionSet.getStatus());
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\nCollect failed with:", e);
                    e.printStackTrace();
                    System.out.println();
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    private CollectionAgent getCollectionAgent() {
        InetAddress hostAddr = InetAddrUtils.addr((String)this.host);
        if (this.nodeCriteria != null) {
            return this.collectionAgentFactory.createCollectionAgentAndOverrideLocation(this.nodeCriteria, hostAddr, this.location);
        }
        System.out.println("NOTE: Some collectors require a database node and IP interface.\n");
        CollectionAgentDTO agent = new CollectionAgentDTO();
        agent.setLocationName(this.location);
        agent.setAddress(hostAddr);
        agent.setStorageResourcePath(ResourcePath.fromString((String)""));
        return agent;
    }

    private static void printCollectionSet(CollectionSet collectionSet) {
        final AtomicBoolean didPrintAttribute = new AtomicBoolean(false);
        collectionSet.visit((CollectionSetVisitor)new AbstractCollectionSetVisitor(){

            public void visitResource(CollectionResource resource) {
                System.out.printf("%s\n", resource);
            }

            public void visitGroup(AttributeGroup group) {
                System.out.printf("\tGroup: %s\n", group.getName());
            }

            public void visitAttribute(CollectionAttribute attribute) {
                System.out.printf("\t\t%s\n", attribute);
                didPrintAttribute.set(true);
            }
        });
        if (!didPrintAttribute.get()) {
            System.out.println("(Empty collection set)");
        }
    }

    private static Map<String, Object> parse(List<String> attributeList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

