/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.commands;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;

@Command(scope="metrics", name="stress", description="Stress the current persistence strategy with generated collection sets.")
@Service
public class StressCommand
implements Action {
    @Reference
    private PersisterFactory persisterFactory;
    @Option(name="-b", aliases={"--burst"}, description="generate the collection sets in bursts instead of continously inserting them, defaults to false", required=false, multiValued=false)
    boolean burst = false;
    @Option(name="-i", aliases={"--interval"}, description="interval in seconds at which collection sets will be generated, defaults to 300", required=false, multiValued=false)
    int intervalInSeconds = 300;
    @Option(name="-n", aliases={"--nodes"}, description="number of nodes for which metrics will be generated, defaults to 1000", required=false, multiValued=false)
    int numberOfNodes = 1000;
    @Option(name="-f", aliases={"--interfaces"}, description="number of interfaces on each node, defaults to 10", required=false, multiValued=false)
    int numberOfInterfacesPerNode = 10;
    @Option(name="-g", aliases={"--groups"}, description="number of groups on each interface, defaults to 5", required=false, multiValued=false)
    int numberOfGroupsPerInterface = 5;
    @Option(name="-a", aliases={"--attributes"}, description="number of number attributes in each group, defaults to 10", required=false, multiValued=false)
    int numberOfNumericAttributesPerGroup = 10;
    @Option(name="-s", aliases={"--strings"}, description="number of string attributes in each group, defaults to 2", required=false, multiValued=false)
    int numberOfStringAttributesPerGroup = 2;
    @Option(name="-r", aliases={"--report"}, description="number of seconds after which the report should be generated, defaults to 30", required=false, multiValued=false)
    int reportIntervalInSeconds = 30;
    @Option(name="-t", aliases={"--threads"}, description="number of threads that will be used to generate and persist collection sets, defaults to 1", required=false, multiValued=false)
    int numberOfGeneratorThreads = 1;
    @Option(name="-z", aliases={"--string-variation-factor"}, description="when set, every n-th group will use unique string attribute values in each batch, defaults to 0", required=false, multiValued=false)
    int stringVariationFactor = 0;
    @Option(name="-x", aliases={"--rra"}, description="Round Robin Archives, defaults to the pritine content on datacollection-config.xml", required=false, multiValued=true)
    List<String> rras = null;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final MetricRegistry metrics = new MetricRegistry();
    final Timer batchTimer = this.metrics.timer("batches");
    private final Meter numericAttributesGenerated = this.metrics.meter("numeric-attributes-generated");
    private final Meter stringAttributesGenerated = this.metrics.meter("string-attributes-generated");
    private Meter stringAttributesVaried;
    private AtomicInteger seed = new AtomicInteger();

    /*
     * Exception decompiling
     */
    public Void execute() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Callable<Void> generateAndPersistCollectionSets(final ServiceParameters params, final RrdRepository repository, final int generatorThreadId, final int sleepTimeInMillisBetweenNodes) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int nodeId = 0; nodeId < StressCommand.this.numberOfNodes; ++nodeId) {
                    if (nodeId % StressCommand.this.numberOfGeneratorThreads != generatorThreadId) continue;
                    MockCollectionAgent agent = new MockCollectionAgent(nodeId);
                    NodeLevelResource nodeResource = new NodeLevelResource(nodeId);
                    Persister persister = StressCommand.this.persisterFactory.createPersister(params, repository);
                    for (int interfaceId = 0; interfaceId < StressCommand.this.numberOfInterfacesPerNode; ++interfaceId) {
                        if (StressCommand.this.abort.get()) {
                            return null;
                        }
                        InterfaceLevelResource interfaceResource = new InterfaceLevelResource(nodeResource, "tap" + interfaceId);
                        CollectionSet collectionSet = StressCommand.this.generateCollectionSet(agent, nodeId, interfaceId, (Resource)interfaceResource);
                        collectionSet.visit((CollectionSetVisitor)persister);
                    }
                    Thread.sleep(sleepTimeInMillisBetweenNodes);
                }
                return null;
            }
        };
    }

    private CollectionSet generateCollectionSet(CollectionAgent agent, int nodeId, int interfaceId, Resource resource) {
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        for (int groupId = 0; groupId < this.numberOfGroupsPerInterface; ++groupId) {
            String groupName = "group" + groupId;
            for (int attributeId = 0; attributeId < this.numberOfNumericAttributesPerGroup; ++attributeId) {
                int value = groupId * attributeId + this.seed.incrementAndGet() % 100;
                builder.withNumericAttribute(resource, groupName, "metric_" + groupId + "_" + attributeId, (Number)value, AttributeType.GAUGE);
                this.numericAttributesGenerated.mark();
            }
            String stringAttributeValueSuffix = "";
            int groupInstance = (nodeId + 1) * (interfaceId + 1) * (groupId + 1);
            if (this.stringVariationFactor > 0 && groupInstance % this.stringVariationFactor == 0) {
                stringAttributeValueSuffix = String.format("-%d-varied", groupInstance);
                this.stringAttributesVaried.mark((long)this.numberOfStringAttributesPerGroup);
            }
            for (int stringAttributeId = 0; stringAttributeId < this.numberOfStringAttributesPerGroup; ++stringAttributeId) {
                String key = String.format("%s-key-%d", groupName, stringAttributeId);
                String value = String.format("%s-value-%d%s", groupName, stringAttributeId, stringAttributeValueSuffix);
                builder.withStringAttribute(resource, groupName, key, value);
                this.stringAttributesGenerated.mark();
            }
        }
        return builder.build();
    }

    private static class MockCollectionAgent
    implements CollectionAgent {
        private final int nodeId;

        public MockCollectionAgent(int nodeId) {
            this.nodeId = nodeId;
        }

        public InetAddress getAddress() {
            return null;
        }

        public Set<String> getAttributeNames() {
            return Collections.emptySet();
        }

        public <V> V getAttribute(String property) {
            return null;
        }

        public Object setAttribute(String property, Object value) {
            return null;
        }

        public Boolean isStoreByForeignSource() {
            return ResourceTypeUtils.isStoreByForeignSource();
        }

        public String getHostAddress() {
            return null;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodeLabel() {
            return Integer.toString(this.nodeId);
        }

        public String getForeignSource() {
            return "STRESS";
        }

        public String getForeignId() {
            return Integer.toString(this.nodeId);
        }

        public String getLocationName() {
            return null;
        }

        public ResourcePath getStorageResourcePath() {
            String foreignSource = this.getForeignSource();
            String foreignId = this.getForeignId();
            ResourcePath dir = this.isStoreByForeignSource() != false && foreignSource != null && foreignId != null ? ResourcePath.get((String[])new String[]{"fs", foreignSource, foreignId}) : ResourcePath.get((String[])new String[]{String.valueOf(this.getNodeId())});
            return dir;
        }

        public long getSavedSysUpTime() {
            return 0L;
        }

        public void setSavedSysUpTime(long sysUpTime) {
        }
    }
}

