/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.client.rpc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectorRequestBuilder;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.client.rpc.CollectorRequestDTO;
import org.opennms.netmgt.collection.client.rpc.LocationAwareCollectorClientImpl;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;

public class CollectorRequestBuilderImpl
implements CollectorRequestBuilder {
    private final LocationAwareCollectorClientImpl client;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private CollectionAgent agent;
    private ServiceCollector serviceCollector;
    private Long ttlInMs;

    public CollectorRequestBuilderImpl(LocationAwareCollectorClientImpl client) {
        this.client = Objects.requireNonNull(client);
    }

    public CollectorRequestBuilder withAgent(CollectionAgent agent) {
        this.agent = agent;
        return this;
    }

    public CollectorRequestBuilder withCollector(ServiceCollector collector) {
        this.serviceCollector = collector;
        return this;
    }

    public CollectorRequestBuilder withCollectorClassName(String className) {
        this.serviceCollector = this.client.getRegistry().getCollectorByClassName(className);
        return this;
    }

    public CollectorRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public CollectorRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public CollectorRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public CompletableFuture<CollectionSet> execute() {
        if (this.serviceCollector == null) {
            throw new IllegalArgumentException("Collector or collector class name is required.");
        }
        if (this.agent == null) {
            throw new IllegalArgumentException("Agent is required.");
        }
        CollectorRequestDTO request = new CollectorRequestDTO();
        request.setLocation(this.serviceCollector.getEffectiveLocation(this.agent.getLocationName()));
        request.setClassName(this.serviceCollector.getClass().getCanonicalName());
        request.setTimeToLiveMs(this.ttlInMs);
        Map runtimeAttributes = this.serviceCollector.getRuntimeAttributes(this.agent, this.attributes);
        HashMap<String, Object> allAttributes = new HashMap<String, Object>();
        allAttributes.putAll(this.attributes);
        allAttributes.putAll(runtimeAttributes);
        if (MonitoringLocationUtils.isDefaultLocationName((String)request.getLocation())) {
            request.setAgent(this.agent);
            request.addAttributes(allAttributes);
        } else {
            request.setAgent((CollectionAgent)new CollectionAgentDTO(this.agent));
            Map marshaledParms = this.serviceCollector.marshalParameters(allAttributes);
            marshaledParms.forEach((k, v) -> request.addAttribute((String)k, v));
            request.setAttributesNeedUnmarshaling(true);
        }
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(results -> results.getCollectionSet());
    }
}

