/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.DelegatingPersister;
import org.opennms.netmgt.rrd.RrdRepository;

public class DelegatingPersisterFactory
implements PersisterFactory {
    private final List<PersisterFactory> delegates;

    public DelegatingPersisterFactory(List<PersisterFactory> delegates) {
        this.delegates = Objects.requireNonNull(delegates);
    }

    public DelegatingPersisterFactory(PersisterFactory delegate1, PersisterFactory delegate2) {
        this.delegates = Arrays.asList(delegate1, delegate2);
    }

    public DelegatingPersisterFactory(PersisterFactory ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return new DelegatingPersister(this.delegates.stream().map(pf -> pf.createPersister(params, repository)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        return new DelegatingPersister(this.delegates.stream().map(pf -> pf.createPersister(params, repository, dontPersistCounters, forceStoreByGroup, dontReorderAttributes)).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

