/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.collection.api.AbstractServiceCollector;

public abstract class AbstractRemoteServiceCollector
extends AbstractServiceCollector {
    private final Map<String, Class<?>> parameterTypeMap;

    public AbstractRemoteServiceCollector() {
        this(Collections.emptyMap());
    }

    public AbstractRemoteServiceCollector(Map<String, Class<?>> parameterTypeMap) {
        this.parameterTypeMap = Objects.requireNonNull(parameterTypeMap);
    }

    @Override
    public String getEffectiveLocation(String location) {
        return location;
    }

    @Override
    public Map<String, String> marshalParameters(Map<String, Object> parameters) {
        HashMap<String, String> marshaledParams = new HashMap<String, String>();
        parameters.forEach((k, v) -> {
            if (v != null) {
                if (v instanceof String) {
                    marshaledParams.put((String)k, (String)v);
                } else {
                    Class<?> clazz = this.parameterTypeMap.get(k);
                    if (clazz == null) {
                        throw new IllegalStateException(String.format("The parameter map for collector %s include a parameters named %s which must be marshaled, but no type mapping was provided. Aborting.", this.getClass().getCanonicalName(), k));
                    }
                    if (!clazz.isAssignableFrom(v.getClass())) {
                        throw new IllegalStateException(String.format("The parameter map for collector %s include a parameters named %s which must be marshaled, but type mapping is incorrect (got %s, but expected %s). Aborting.", this.getClass().getCanonicalName(), k, v.getClass(), clazz));
                    }
                    marshaledParams.put((String)k, JaxbUtils.marshal((Object)v));
                }
            }
        });
        return marshaledParams;
    }

    @Override
    public Map<String, Object> unmarshalParameters(Map<String, String> parameters) {
        HashMap<String, Object> unmarshaledParams = new HashMap<String, Object>();
        parameters.forEach((k, v) -> {
            if (v != null) {
                Class<?> clazz = this.parameterTypeMap.get(k);
                if (clazz == null) {
                    unmarshaledParams.put((String)k, v);
                } else {
                    unmarshaledParams.put((String)k, JaxbUtils.unmarshal(clazz, (String)v));
                }
            }
        });
        return unmarshaledParams;
    }
}

