/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import org.opennms.netmgt.collection.api.AttributeType;

public abstract class Attribute<T> {
    private final String m_group;
    private final String m_name;
    private final T m_value;
    private final AttributeType m_type;
    private final String m_identifier;

    public Attribute(String group, String name, T value, AttributeType type, String identifier) {
        this.m_group = Objects.requireNonNull(group, "group argument");
        this.m_name = Objects.requireNonNull(name, "name argument");
        this.m_value = Objects.requireNonNull(value, "value argument");
        this.m_type = Objects.requireNonNull(type, "type argument");
        this.m_identifier = identifier;
    }

    public abstract Number getNumericValue();

    public abstract String getStringValue();

    public String getGroup() {
        return this.m_group;
    }

    public String getName() {
        return this.m_name;
    }

    public T getValue() {
        return this.m_value;
    }

    public AttributeType getType() {
        return this.m_type;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String toString() {
        return String.format("Attribute[group=%s, name=%s, value=%s, type=%s, identifier=%s]", new Object[]{this.m_group, this.m_name, this.m_value, this.m_type, this.m_identifier});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_group, this.m_name, this.m_value, this.m_type, this.m_identifier});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equals(this.m_group, other.m_group) && Objects.equals(this.m_name, other.m_name) && Objects.equals((Object)this.m_type, (Object)other.m_type) && Objects.equals(this.m_identifier, other.m_identifier);
    }
}

