/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCollectorRegistry
implements ServiceCollectorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCollectorRegistry.class);
    private static final String TYPE = "type";
    private static final ServiceLoader<ServiceCollector> s_serviceCollectorLoader = ServiceLoader.load(ServiceCollector.class);
    private final Map<String, ServiceCollector> m_collectorsByClassName = new HashMap<String, ServiceCollector>();

    public DefaultServiceCollectorRegistry() {
        for (ServiceCollector serviceCollector : s_serviceCollectorLoader) {
            HashMap<String, String> props = new HashMap<String, String>(1);
            props.put(TYPE, serviceCollector.getClass().getCanonicalName());
            this.onBind(serviceCollector, props);
        }
    }

    public synchronized void onBind(ServiceCollector serviceCollector, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)serviceCollector, (Object)properties);
        if (serviceCollector != null) {
            String className = DefaultServiceCollectorRegistry.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for collector: {}, with properties: {}. The monitor will not be registered.", (Object)serviceCollector, (Object)properties);
                return;
            }
            this.m_collectorsByClassName.put(className, serviceCollector);
        }
    }

    public synchronized void onUnbind(ServiceCollector serviceCollector, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)serviceCollector, (Object)properties);
        if (serviceCollector != null) {
            String className = DefaultServiceCollectorRegistry.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for collector: {}, with properties: {}. The monitor will not be unregistered.", (Object)serviceCollector, (Object)properties);
                return;
            }
            this.m_collectorsByClassName.remove(className, serviceCollector);
        }
    }

    @Override
    public ServiceCollector getCollectorByClassName(String className) {
        return this.m_collectorsByClassName.get(className);
    }

    @Override
    public Set<String> getCollectorClassNames() {
        return Collections.unmodifiableSet(this.m_collectorsByClassName.keySet());
    }

    private static String getClassName(Map<?, ?> properties) {
        Object type = properties.get(TYPE);
        if (type != null && type instanceof String) {
            return (String)type;
        }
        return null;
    }
}

