/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceParameters {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceParameters.class);
    private final Map<String, Object> m_parameters;

    public ServiceParameters(Map<String, Object> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        return "domain: " + this.getDomain() + ", " + "storeByNodeID: " + this.getStoreByNodeID() + ", " + "storeByIfAlias: " + this.getStoreByIfAlias() + ", " + "storeFlagOverride: " + this.getStorFlagOverride() + ", " + "ifAliasComment: " + this.getIfAliasComment();
    }

    public String getDomain() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.DOMAIN.toString(), (String)"default");
    }

    public String getStoreByNodeID() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.STOREBYNODEID.toString(), (String)"normal");
    }

    public String getStoreByIfAlias() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.STOREBYIFALIAS.toString(), (String)"false");
    }

    public String getStorFlagOverride() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.STORFLAGOVERRIDE.toString(), (String)"false");
    }

    public String getIfAliasComment() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.IFALIASCOMMENT.toString(), null);
    }

    public boolean aliasesEnabled() {
        return this.getStoreByIfAlias().equals("true");
    }

    public boolean overrideStorageFlag() {
        return !this.getStorFlagOverride().equals("false");
    }

    public void logIfAliasConfig() {
        LOG.info("logIfAliasConfig: {}", (Object)this);
    }

    public boolean forceStoreByAlias(String alias) {
        if (alias == null || alias.equals("")) {
            return false;
        }
        String comment = this.getIfAliasComment();
        int si = -1;
        if (comment != null && !comment.equals("")) {
            si = alias.indexOf(comment);
        }
        if (si == 0) {
            return false;
        }
        return this.overrideStorageFlag();
    }

    public String getCollectionName() {
        if (this.getParameters().containsKey("collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.COLLECTION.toString(), (String)"default");
        }
        if (this.getParameters().containsKey("http-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.HTTP_COLLECTION.toString(), (String)"default");
        }
        if (this.getParameters().containsKey("nsclient-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.NSCLIENT_COLLECTION.toString(), (String)"default");
        }
        if (this.m_parameters.containsKey("wmi-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.WMI_COLLECTION.toString(), (String)"default");
        }
        return "default";
    }

    public int getSnmpPort(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)ParameterName.PORT.toString(), (int)current);
    }

    public int getSnmpRetries(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)ParameterName.RETRY.toString(), (int)current);
    }

    public int getSnmpTimeout(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)ParameterName.TIMEOUT.toString(), (int)current);
    }

    public String getSnmpReadCommunity(String current) {
        String readCommunity = ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.READ_COMMUNITY.toString(), null);
        if (readCommunity == null) {
            readCommunity = ParameterMap.getKeyedString(this.m_parameters, (String)ParameterName.READCOMMUNITY.toString(), (String)current);
        }
        return readCommunity;
    }

    public String getSnmpWriteCommunity(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.WRITE_COMMUNITY.toString(), (String)current);
    }

    public InetAddress getSnmpProxyFor(InetAddress current) {
        String address = ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.PROXY_HOST.toString(), null);
        InetAddress addr = null;
        if (address != null && (addr = InetAddressUtils.addr((String)address)) == null) {
            LOG.error("determineProxyHost: Problem converting proxy host string to InetAddress");
        }
        return addr == null ? current : addr;
    }

    public int getSnmpVersion(int current) {
        String version = ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.VERSION.toString(), null);
        if (version != null) {
            if (version.equals("v1")) {
                return 1;
            }
            if (version.equals("v2c")) {
                return 2;
            }
            if (version.equals("v3")) {
                return 3;
            }
        }
        return current;
    }

    public int getSnmpMaxVarsPerPdu(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)ParameterName.MAX_VARS_PER_PDU.toString(), (int)current);
    }

    public int getSnmpMaxRepetitions(int current) {
        int maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)ParameterName.MAX_REPETITIONS.toString(), (int)-1);
        if (maxRepetitions == -1) {
            maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)ParameterName.MAXREPETITIONS.toString(), (int)current);
        }
        return maxRepetitions;
    }

    public int getSnmpMaxRequestSize(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)ParameterName.MAX_REQUEST_SIZE.toString(), (int)current);
    }

    public String getSnmpSecurityName(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.SECURITY_NAME.toString(), (String)current);
    }

    public String getSnmpAuthPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.AUTH_PASSPHRASE.toString(), (String)current);
    }

    public String getSnmpAuthProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.AUTH_PROTOCOL.toString(), (String)current);
    }

    public String getSnmpPrivPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.PRIVACY_PASSPHRASE.toString(), (String)current);
    }

    public String getSnmpPrivProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.PRIVACY_PROTOCOL.toString(), (String)current);
    }

    public String getPackageName() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.PACKAGE_NAME.toString(), (String)"unknown");
    }

    public Long getServiceInterval() {
        String intervalAsStr = ParameterMap.getKeyedString(this.getParameters(), (String)ParameterName.SERVICE_INTERVAL.toString(), null);
        if (intervalAsStr == null) {
            return null;
        }
        try {
            return Long.parseLong(intervalAsStr);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid interval " + intervalAsStr, nfe);
        }
    }

    public static enum ParameterName {
        DOMAIN("domain"),
        STOREBYNODEID("storeByNodeID"),
        STOREBYIFALIAS("storeByIfAlias"),
        STORFLAGOVERRIDE("storFlagOverride"),
        IFALIASCOMMENT("ifAliasComment"),
        COLLECTION("collection"),
        HTTP_COLLECTION("http-collection"),
        NSCLIENT_COLLECTION("nsclient-collection"),
        WMI_COLLECTION("wmi-collection"),
        PORT("port"),
        RETRY("retry"),
        RETRIES("retries"),
        TIMEOUT("timeout"),
        READ_COMMUNITY("read-community"),
        READCOMMUNITY("readCommunity"),
        WRITE_COMMUNITY("write-community"),
        PROXY_HOST("proxy-host"),
        VERSION("version"),
        MAX_VARS_PER_PDU("max-vars-per-pdu"),
        MAX_REPETITIONS("max-repetitions"),
        MAXREPETITIONS("maxRepetitions"),
        MAX_REQUEST_SIZE("max-request-size"),
        SECURITY_NAME("security-name"),
        AUTH_PASSPHRASE("auth-passphrase"),
        AUTH_PROTOCOL("auth-protocol"),
        PRIVACY_PASSPHRASE("privacy-passphrase"),
        PRIVACY_PROTOCOL("privacy-protocol"),
        USE_MBEAN_NAME_FOR_RRDS("use-mbean-name-for-rrds"),
        FRIENDLY_NAME("friendly-name"),
        PACKAGE_NAME("packageName"),
        SERVICE("SERVICE"),
        SERVICE_INTERVAL("SERVICE_INTERVAL");

        private final String m_value;

        private ParameterName(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

