/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.GenericTypeResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistenceSelectorStrategy;
import org.opennms.netmgt.collection.api.ResourceType;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;
import org.springframework.orm.ObjectRetrievalFailureException;

@XmlJavaTypeAdapter(value=GenericTypeResourceAdapter.class)
public class GenericTypeResource
implements Resource {
    private final NodeLevelResource m_node;
    private final String m_instance;
    private final ResourceType m_resourceType;
    private final StorageStrategy m_storageStrategy;
    private final PersistenceSelectorStrategy m_persistenceSelectorStrategy;

    public GenericTypeResource(NodeLevelResource node, ResourceType resourceType, String instance) {
        this.m_node = Objects.requireNonNull(node, "node argument");
        this.m_instance = Objects.requireNonNull(instance, "instance argument");
        this.m_resourceType = Objects.requireNonNull(resourceType, "resourceType argument");
        this.m_storageStrategy = this.instantiateStorageStrategy(this.m_resourceType.getStorageStrategy().getClazz());
        this.m_storageStrategy.setParameters(this.m_resourceType.getStorageStrategy().getParameters());
        this.m_persistenceSelectorStrategy = this.instantiatePersistenceSelector(this.m_resourceType.getPersistenceSelectorStrategy().getClazz());
        this.m_persistenceSelectorStrategy.setParameters(this.m_resourceType.getPersistenceSelectorStrategy().getParameters());
    }

    @Override
    public NodeLevelResource getParent() {
        return this.m_node;
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        return this.getStorageStrategy().getRelativePathForAttribute(ResourcePath.get((String[])new String[0]), this.getStorageStrategy().getResourceNameFromIndex(resource));
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public PersistenceSelectorStrategy getPersistenceSelectorStrategy() {
        return this.m_persistenceSelectorStrategy;
    }

    private StorageStrategy instantiateStorageStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            StorageStrategy storageStrategy = (StorageStrategy)cinst.newInstance();
            storageStrategy.setResourceTypeName(this.m_resourceType.getName());
            return storageStrategy;
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    private PersistenceSelectorStrategy instantiatePersistenceSelector(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            return (PersistenceSelectorStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("GenericTypeResource[node=%s, instance=%s, resourceType=%s,storageStrategy=%s, persistenceSelectorStrategy=%s", this.m_node, this.m_instance, this.m_resourceType, this.m_storageStrategy, this.m_persistenceSelectorStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_instance, this.m_resourceType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericTypeResource)) {
            return false;
        }
        GenericTypeResource other = (GenericTypeResource)obj;
        return Objects.equals(this.m_node, other.m_node) && Objects.equals(this.m_instance, other.m_instance) && Objects.equals(this.m_resourceType, other.m_resourceType);
    }
}

