/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import org.opennms.netmgt.collection.support.builder.AttributeType;
import org.opennms.netmgt.collection.support.builder.Resource;

public abstract class Attribute<T> {
    private final Resource m_resource;
    private final String m_group;
    private final String m_name;
    private final T m_value;
    private final AttributeType m_type;

    public Attribute(Resource resource, String group, String name, T value, AttributeType type) {
        this.m_resource = Objects.requireNonNull(resource, "resource argument");
        this.m_group = Objects.requireNonNull(group, "group argument");
        this.m_name = Objects.requireNonNull(name, "name argument");
        this.m_value = Objects.requireNonNull(value, "value argument");
        this.m_type = Objects.requireNonNull(type, "type argument");
    }

    public abstract Number getNumericValue();

    public abstract String getStringValue();

    public Resource getResource() {
        return this.m_resource;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getName() {
        return this.m_name;
    }

    public T getValue() {
        return this.m_value;
    }

    public AttributeType getType() {
        return this.m_type;
    }
}

