/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionVisitable;
import org.opennms.netmgt.collection.api.Persistable;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeGroup
implements CollectionVisitable,
Persistable {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeGroup.class);
    private final CollectionResource m_resource;
    private final AttributeGroupType m_groupType;
    private final Set<CollectionAttribute> m_attributes = new LinkedHashSet<CollectionAttribute>();

    public AttributeGroup(CollectionResource resource, AttributeGroupType groupType) {
        this.m_resource = resource;
        this.m_groupType = groupType;
    }

    public String getName() {
        return this.m_groupType.getName();
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public Collection<CollectionAttribute> getAttributes() {
        return this.m_attributes;
    }

    public void addAttribute(CollectionAttribute attr) {
        this.m_attributes.add(attr);
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        LOG.debug("Visiting Group {}", (Object)this);
        visitor.visitGroup(this);
        for (CollectionAttribute attr : this.getAttributes()) {
            attr.visit(visitor);
        }
        visitor.completeGroup(this);
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        boolean shouldPersist = this.doShouldPersist();
        LOG.debug("{}.shouldPersist = {}", (Object)this, (Object)shouldPersist);
        return shouldPersist;
    }

    protected boolean doShouldPersist() {
        if ("ignore".equalsIgnoreCase(this.getIfType())) {
            return true;
        }
        return "all".equalsIgnoreCase(this.getIfType());
    }

    protected String getIfType() {
        return this.m_groupType.getIfType();
    }

    public AttributeGroupType getGroupType() {
        return this.m_groupType;
    }

    public String toString() {
        return this.m_groupType + " for " + this.m_resource.getInstance() + "@" + this.m_resource.getParent();
    }
}

