/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.nio.file.Path;
import java.util.Objects;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistenceSelectorStrategy;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.springframework.orm.ObjectRetrievalFailureException;

public class GenericTypeResource
implements Resource {
    private final NodeLevelResource m_node;
    private final String m_instance;
    private final ResourceType m_resourceType;
    private final StorageStrategy m_storageStrategy;
    private final PersistenceSelectorStrategy m_persistenceSelectorStrategy;

    public GenericTypeResource(NodeLevelResource node, ResourceType resourceType, String instance) {
        this.m_node = Objects.requireNonNull(node, "node argument");
        this.m_instance = Objects.requireNonNull(instance, "instance argument");
        this.m_resourceType = Objects.requireNonNull(resourceType, "resourceType argument");
        this.m_storageStrategy = this.instantiateStorageStrategy(this.m_resourceType.getStorageStrategy().getClazz());
        this.m_storageStrategy.setParameters(this.m_resourceType.getStorageStrategy().getParameters());
        this.m_persistenceSelectorStrategy = this.instantiatePersistenceSelector(this.m_resourceType.getPersistenceSelectorStrategy().getClazz());
        this.m_persistenceSelectorStrategy.setParameters(this.m_resourceType.getPersistenceSelectorStrategy().getParameters());
    }

    @Override
    public NodeLevelResource getParent() {
        return this.m_node;
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    @Override
    public String getLabel(CollectionResource resource) {
        return this.m_storageStrategy.getResourceNameFromIndex(resource);
    }

    @Override
    public Path getPath(CollectionResource resource) {
        return this.getStorageStrategy().getRelativePathForAttribute("", this.getStorageStrategy().getResourceNameFromIndex(resource));
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public PersistenceSelectorStrategy getPersistenceSelectorStrategy() {
        return this.m_persistenceSelectorStrategy;
    }

    private StorageStrategy instantiateStorageStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            StorageStrategy storageStrategy = (StorageStrategy)cinst.newInstance();
            storageStrategy.setResourceTypeName(this.m_resourceType.getName());
            return storageStrategy;
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    private PersistenceSelectorStrategy instantiatePersistenceSelector(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            return (PersistenceSelectorStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    @Override
    public String getTypeName() {
        return this.m_resourceType.getName();
    }

    public String toString() {
        return String.format("GenericTypeResource[node=%s, resourceType=%s,storageStrategy=%s, persistenceSelectorStrategy=%s", this.m_node, this.m_resourceType, this.m_storageStrategy, this.m_persistenceSelectorStrategy);
    }
}

