/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.nio.file.Path;
import java.util.LinkedList;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersister
extends AbstractCollectionSetVisitor
implements Persister {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractPersister.class);
    private boolean m_ignorePersist = false;
    private ServiceParameters m_params;
    private RrdRepository m_repository;
    private final LinkedList<Boolean> m_stack = new LinkedList();
    private PersistOperationBuilder m_builder;

    protected abstract void persistStringAttribute(ResourcePath var1, String var2, String var3) throws PersistException;

    protected AbstractPersister(ServiceParameters params, RrdRepository repository) {
        this.m_params = params;
        this.m_repository = repository;
    }

    public void commitBuilder() {
        if (this.isPersistDisabled()) {
            return;
        }
        String name = this.m_builder.getName();
        try {
            this.m_builder.commit();
            this.m_builder = null;
        }
        catch (PersistException e) {
            LOG.error("Unable to persist data for {}", (Object)name, (Object)e);
        }
    }

    private boolean isPersistDisabled() {
        return this.m_params != null && this.m_params.getParameters().containsKey("storing-enabled") && "false".equals(this.m_params.getParameters().get("storing-enabled"));
    }

    @Override
    public void completeAttribute(CollectionAttribute attribute) {
        this.popShouldPersist();
    }

    @Override
    public void completeGroup(AttributeGroup group) {
        this.popShouldPersist();
    }

    @Override
    public void completeResource(CollectionResource resource) {
        this.popShouldPersist();
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(RrdRepository repository) {
        this.m_repository = repository;
    }

    @Override
    public void persistNumericAttribute(CollectionAttribute attribute) {
        boolean shouldIgnorePersist = this.isIgnorePersist() && attribute.getType().toLowerCase().startsWith("counter");
        LOG.debug("Persisting {} {}", (Object)attribute, (Object)(shouldIgnorePersist ? ". Ignoring value because of sysUpTime changed." : ""));
        Number value = shouldIgnorePersist ? (Number)Double.NaN : (Number)attribute.getNumericValue();
        this.m_builder.setAttributeValue(attribute.getAttributeType(), value);
        this.m_builder.setAttributeMetadata(attribute.getMetricIdentifier(), attribute.getName());
    }

    @Override
    public void persistStringAttribute(CollectionAttribute attribute) {
        LOG.debug("Persisting {}", (Object)attribute);
        CollectionResource resource = attribute.getResource();
        String value = attribute.getStringValue();
        if (value == null) {
            LOG.info("No data collected for attribute {}.  Skipping.", (Object)attribute);
            return;
        }
        try {
            ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (Path)resource.getPath());
            this.persistStringAttribute(path, attribute.getName(), value);
        }
        catch (PersistException e) {
            LOG.error("Unable to save string attribute {}.", (Object)attribute, (Object)e);
        }
    }

    public boolean popShouldPersist() {
        boolean top = this.top();
        this.m_stack.removeLast();
        return top;
    }

    private void push(boolean b) {
        this.m_stack.addLast(b);
    }

    public void pushShouldPersist(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute.shouldPersist(this.m_params));
    }

    protected void pushShouldPersist(AttributeGroup group) {
        this.pushShouldPersist(group.shouldPersist(this.m_params));
    }

    private void pushShouldPersist(boolean shouldPersist) {
        this.push(this.top() && shouldPersist);
    }

    public void pushShouldPersist(CollectionResource resource) {
        this.push(resource.shouldPersist(this.m_params));
    }

    protected boolean shouldPersist() {
        return this.top();
    }

    public void storeAttribute(CollectionAttribute attribute) {
        if (this.shouldPersist()) {
            attribute.storeAttribute(this);
            LOG.debug("Storing attribute {}", (Object)attribute);
        } else {
            LOG.debug("Not persisting attribute {} because shouldPersist is false", (Object)attribute);
        }
    }

    private boolean top() {
        return this.m_stack.getLast();
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute);
        this.storeAttribute(attribute);
    }

    @Override
    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
    }

    @Override
    public void visitResource(CollectionResource resource) {
        LOG.info("Persisting data for resource {}", (Object)resource);
        this.pushShouldPersist(resource);
    }

    public boolean isIgnorePersist() {
        return this.m_ignorePersist;
    }

    public void setIgnorePersist(boolean ignore) {
        this.m_ignorePersist = ignore;
    }

    protected void setBuilder(PersistOperationBuilder builder) {
        this.m_builder = builder;
    }
}

