/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.collection.api.ByNameComparator;
import org.opennms.netmgt.collection.api.CollectionAttributeType;

public class AttributeGroupType {
    private final String m_name;
    private final String m_ifType;
    public static final String IF_TYPE_ALL = "all";
    public static final String IF_TYPE_IGNORE = "ignore";
    private SortedSet<CollectionAttributeType> m_attributeTypes = new TreeSet<CollectionAttributeType>(new ByNameComparator());

    public AttributeGroupType(String groupName, String groupIfType) {
        if (groupName == null) {
            throw new NullPointerException("groupName cannot be null");
        }
        if (groupIfType == null) {
            throw new NullPointerException("groupIfType cannot be null");
        }
        this.m_name = groupName;
        this.m_ifType = groupIfType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeGroupType) {
            AttributeGroupType groupType = (AttributeGroupType)obj;
            return this.m_name.equals(groupType.m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String getIfType() {
        return this.m_ifType;
    }

    public String getName() {
        return this.m_name;
    }

    public void addAttributeType(CollectionAttributeType attrType) {
        this.m_attributeTypes.add(attrType);
    }

    public SortedSet<CollectionAttributeType> getAttributeTypes() {
        return Collections.unmodifiableSortedSet(this.m_attributeTypes);
    }

    public String toString() {
        return "AttrGroupType[name=" + this.m_name + ", ifType=" + this.m_ifType + ']';
    }
}

