/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import java.util.Map;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceContainer;

public class BusinessServiceFilter
implements Container.Filter {
    public static final String NAME_PROPERTY = "name";
    private BusinessServiceContainer businessServiceContainer;
    private String filter;

    public BusinessServiceFilter(BusinessServiceContainer businessServiceContainer, String filter) {
        this.businessServiceContainer = businessServiceContainer;
        this.filter = filter.toLowerCase();
    }

    public boolean passesFilter(Object itemId, Item item) {
        Property property = item.getItemProperty((Object)NAME_PROPERTY);
        return this.checkSuccessor(itemId, property) || this.checkPredecessor(itemId, property);
    }

    private boolean checkPredecessor(Object itemId, Property<?> property) {
        if (property != null && property.getValue() != null && ((String)property.getValue()).toLowerCase().contains(this.filter)) {
            return true;
        }
        for (Map.Entry<Long, Long> entry : this.businessServiceContainer.getRowIdToParentRowIdMapping().entrySet()) {
            if (!itemId.equals(entry.getValue()) || !this.checkPredecessor(entry.getKey(), this.businessServiceContainer.getContainerProperty(entry.getKey(), NAME_PROPERTY))) continue;
            return true;
        }
        return false;
    }

    private boolean checkSuccessor(Object itemId, Property<?> property) {
        if (property != null && property.getValue() != null && ((String)property.getValue()).toLowerCase().contains(this.filter)) {
            return true;
        }
        for (Map.Entry<Long, Long> entry : this.businessServiceContainer.getRowIdToParentRowIdMapping().entrySet()) {
            if (!itemId.equals(entry.getKey()) || !this.checkSuccessor(entry.getValue(), this.businessServiceContainer.getContainerProperty(entry.getValue(), NAME_PROPERTY))) continue;
            return true;
        }
        return false;
    }

    public boolean appliesToProperty(Object propertyId) {
        return NAME_PROPERTY.equals(propertyId);
    }
}

