/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.google.common.collect.Maps;
import com.vaadin.v7.data.util.BeanContainer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceRow;

public class BusinessServiceContainer
extends BeanContainer<Long, BusinessServiceRow> {
    private final AtomicLong rowIdCounter = new AtomicLong(0L);
    private final Map<Long, Long> rowIdToParentRowIdMapping = Maps.newHashMap();

    public BusinessServiceContainer() {
        super(BusinessServiceRow.class);
        this.setBeanIdProperty("rowId");
    }

    public void addRow(BusinessServiceGraph graph, GraphVertex v) {
        this.createRowForVertex(graph, v, null);
    }

    private void createRowForVertex(BusinessServiceGraph graph, GraphVertex graphVertex, BusinessServiceRow parentRow) {
        BusinessService businessService = graphVertex.getBusinessService();
        if (businessService == null) {
            return;
        }
        long rowId = this.rowIdCounter.incrementAndGet();
        Long parentBusinessServiceId = parentRow != null ? parentRow.getBusinessService().getId() : null;
        BusinessServiceRow row = new BusinessServiceRow(rowId, businessService, parentBusinessServiceId);
        if (parentRow != null) {
            this.rowIdToParentRowIdMapping.put(rowId, parentRow.getRowId());
        }
        this.addBean(row);
        graph.getOutEdges((Object)graphVertex).stream().map(e -> (GraphVertex)graph.getOpposite((Object)graphVertex, e)).filter(v -> v.getBusinessService() != null).sorted((v1, v2) -> v1.getBusinessService().getName().compareTo(v2.getBusinessService().getName())).forEach(v -> this.createRowForVertex(graph, (GraphVertex)v, row));
    }

    protected Map<Long, Long> getRowIdToParentRowIdMapping() {
        return Collections.unmodifiableMap(this.rowIdToParentRowIdMapping);
    }
}

