/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.ListSelect;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ApplicationEdge;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.EdgeVisitor;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.SetTo;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ExponentialPropagation;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverity;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverityAbove;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.Threshold;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEdgeEditWindow;
import org.opennms.netmgt.vaadin.core.KeyValueInputDialogWindow;
import org.opennms.netmgt.vaadin.core.TransactionAwareUI;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceEditWindow
extends Window {
    private static final long serialVersionUID = 6335020396458093845L;
    private final BusinessService m_businessService;
    private TextField m_nameTextField;
    private NativeSelect m_reduceFunctionNativeSelect;
    private NativeSelect m_thresholdStatusSelect;
    private TextField m_thresholdTextField;
    private TextField m_exponentialPropagationBaseTextField;
    private ListSelect m_edgesListSelect;
    private ListSelect m_attributesListSelect;
    private Set<String> m_businessServiceNames;

    public BusinessServiceEditWindow(final BusinessService businessService, BusinessServiceManager businessServiceManager) {
        super("Business Service Edit");
        this.m_businessService = businessService;
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        this.setWidth(650.0f, Sizeable.Unit.PIXELS);
        this.setHeight(550.0f, Sizeable.Unit.PIXELS);
        this.m_businessServiceNames = businessServiceManager.getAllBusinessServices().stream().map(BusinessService::getName).collect(Collectors.toSet());
        if (this.m_businessService.getName() != null) {
            this.m_businessServiceNames.remove(this.m_businessService.getName());
        }
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setSizeFull();
        verticalLayout.setSpacing(true);
        verticalLayout.setMargin(true);
        Button saveButton = new Button("Save");
        saveButton.setId("saveButton");
        saveButton.addClickListener((Button.ClickListener)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Object)new Button.ClickListener(){
            private static final long serialVersionUID = -5985304347211214365L;

            public void buttonClick(Button.ClickEvent event) {
                if (!(BusinessServiceEditWindow.this.m_thresholdTextField.isValid() && BusinessServiceEditWindow.this.m_nameTextField.isValid() && BusinessServiceEditWindow.this.m_exponentialPropagationBaseTextField.isValid())) {
                    return;
                }
                ReductionFunction reductionFunction = this.getReduceFunction();
                businessService.setName(((String)BusinessServiceEditWindow.this.m_nameTextField.getValue()).trim());
                businessService.setReduceFunction(reductionFunction);
                businessService.save();
                BusinessServiceEditWindow.this.close();
            }

            private ReductionFunction getReduceFunction() {
                try {
                    ReductionFunction reductionFunction = (ReductionFunction)((Class)BusinessServiceEditWindow.this.m_reduceFunctionNativeSelect.getValue()).newInstance();
                    reductionFunction.accept((ReduceFunctionVisitor)new ReduceFunctionVisitor<Void>(){

                        public Void visit(HighestSeverity highestSeverity) {
                            return null;
                        }

                        public Void visit(HighestSeverityAbove highestSeverityAbove) {
                            highestSeverityAbove.setThreshold((Status)BusinessServiceEditWindow.this.m_thresholdStatusSelect.getValue());
                            return null;
                        }

                        public Void visit(Threshold threshold) {
                            threshold.setThreshold(Float.parseFloat((String)BusinessServiceEditWindow.this.m_thresholdTextField.getValue()));
                            return null;
                        }

                        public Void visit(ExponentialPropagation exponentialPropagation) {
                            exponentialPropagation.setBase(Double.parseDouble((String)BusinessServiceEditWindow.this.m_exponentialPropagationBaseTextField.getValue()));
                            return null;
                        }
                    });
                    return reductionFunction;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
        Button cancelButton = new Button("Cancel");
        cancelButton.setId("cancelButton");
        cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5306168797758047745L;

            public void buttonClick(Button.ClickEvent event) {
                BusinessServiceEditWindow.this.close();
            }
        });
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        buttonLayout.addComponent((Component)saveButton);
        buttonLayout.addComponent((Component)cancelButton);
        this.m_nameTextField = new TextField("Business Service Name");
        this.m_nameTextField.setId("nameField");
        this.m_nameTextField.setNullRepresentation("");
        this.m_nameTextField.setNullSettingAllowed(true);
        this.m_nameTextField.setValue(businessService.getName());
        this.m_nameTextField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_nameTextField.setRequired(true);
        this.m_nameTextField.focus();
        this.m_nameTextField.addValidator((Validator)new AbstractStringValidator("Name must be unique"){
            private static final long serialVersionUID = 1L;

            protected boolean isValidValue(String value) {
                return value != null && !BusinessServiceEditWindow.this.m_businessServiceNames.contains(value);
            }
        });
        verticalLayout.addComponent((Component)this.m_nameTextField);
        this.m_reduceFunctionNativeSelect = new NativeSelect("Reduce Function", (Collection)ImmutableList.builder().add(HighestSeverity.class).add(Threshold.class).add(HighestSeverityAbove.class).add(ExponentialPropagation.class).build());
        this.m_reduceFunctionNativeSelect.setId("reduceFunctionNativeSelect");
        this.m_reduceFunctionNativeSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_reduceFunctionNativeSelect.setNullSelectionAllowed(false);
        this.m_reduceFunctionNativeSelect.setMultiSelect(false);
        this.m_reduceFunctionNativeSelect.setImmediate(true);
        this.m_reduceFunctionNativeSelect.setNewItemsAllowed(false);
        this.m_reduceFunctionNativeSelect.getItemIds().forEach(itemId -> this.m_reduceFunctionNativeSelect.setItemCaption(itemId, ((Class)itemId).getSimpleName()));
        verticalLayout.addComponent((Component)this.m_reduceFunctionNativeSelect);
        this.m_thresholdTextField = new TextField("Threshold");
        this.m_thresholdTextField.setId("thresholdTextField");
        this.m_thresholdTextField.setRequired(false);
        this.m_thresholdTextField.setEnabled(false);
        this.m_thresholdTextField.setImmediate(true);
        this.m_thresholdTextField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_thresholdTextField.setValue("0.0");
        this.m_thresholdTextField.addValidator((Validator & Serializable)v -> {
            if (this.m_thresholdTextField.isEnabled()) {
                try {
                    float value = Float.parseFloat((String)this.m_thresholdTextField.getValue());
                    if (0.0f >= value || (double)value > 1.0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new Validator.InvalidValueException("Threshold must be a positive number");
                }
            }
        });
        verticalLayout.addComponent((Component)this.m_thresholdTextField);
        this.m_exponentialPropagationBaseTextField = new TextField("Base");
        this.m_exponentialPropagationBaseTextField.setId("exponentialPropagationBaseTextField");
        this.m_exponentialPropagationBaseTextField.setRequired(false);
        this.m_exponentialPropagationBaseTextField.setEnabled(false);
        this.m_exponentialPropagationBaseTextField.setImmediate(true);
        this.m_exponentialPropagationBaseTextField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_exponentialPropagationBaseTextField.setValue("2.0");
        this.m_exponentialPropagationBaseTextField.addValidator((Validator & Serializable)v -> {
            if (this.m_exponentialPropagationBaseTextField.isEnabled()) {
                try {
                    double value = Double.parseDouble((String)this.m_exponentialPropagationBaseTextField.getValue());
                    if (value <= 1.0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new Validator.InvalidValueException("Base must be greater than 1.0");
                }
            }
        });
        verticalLayout.addComponent((Component)this.m_exponentialPropagationBaseTextField);
        this.m_thresholdStatusSelect = new NativeSelect("Threshold");
        this.m_thresholdStatusSelect.setId("thresholdStatusSelect");
        this.m_thresholdStatusSelect.setRequired(false);
        this.m_thresholdStatusSelect.setEnabled(false);
        this.m_thresholdStatusSelect.setImmediate(true);
        this.m_thresholdStatusSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_thresholdStatusSelect.setMultiSelect(false);
        this.m_thresholdStatusSelect.setNewItemsAllowed(false);
        this.m_thresholdStatusSelect.setNullSelectionAllowed(false);
        for (Status eachStatus : Status.values()) {
            this.m_thresholdStatusSelect.addItem((Object)eachStatus);
        }
        this.m_thresholdStatusSelect.setValue((Object)Status.INDETERMINATE);
        this.m_thresholdStatusSelect.getItemIds().forEach(itemId -> this.m_thresholdStatusSelect.setItemCaption(itemId, ((Status)itemId).getLabel()));
        verticalLayout.addComponent((Component)this.m_thresholdStatusSelect);
        this.m_reduceFunctionNativeSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)ev -> {
            boolean thresholdFunction = this.m_reduceFunctionNativeSelect.getValue() == Threshold.class;
            boolean highestSeverityAboveFunction = this.m_reduceFunctionNativeSelect.getValue() == HighestSeverityAbove.class;
            boolean exponentialPropagationFunction = this.m_reduceFunctionNativeSelect.getValue() == ExponentialPropagation.class;
            int height = 550;
            if (thresholdFunction) {
                height += 45;
            }
            if (highestSeverityAboveFunction) {
                height += 40;
            }
            this.setHeight(height, Sizeable.Unit.PIXELS);
            this.setVisible((Field<?>)this.m_thresholdTextField, thresholdFunction);
            this.setVisible((Field<?>)this.m_thresholdStatusSelect, highestSeverityAboveFunction);
            this.setVisible((Field<?>)this.m_exponentialPropagationBaseTextField, exponentialPropagationFunction);
        });
        if (Objects.isNull(businessService.getReduceFunction())) {
            this.m_reduceFunctionNativeSelect.setValue(HighestSeverity.class);
        } else {
            this.m_reduceFunctionNativeSelect.setValue(businessService.getReduceFunction().getClass());
            businessService.getReduceFunction().accept((ReduceFunctionVisitor)new ReduceFunctionVisitor<Void>(){

                public Void visit(HighestSeverity highestSeverity) {
                    return null;
                }

                public Void visit(HighestSeverityAbove highestSeverityAbove) {
                    BusinessServiceEditWindow.this.m_thresholdStatusSelect.setValue((Object)highestSeverityAbove.getThreshold());
                    return null;
                }

                public Void visit(Threshold threshold) {
                    BusinessServiceEditWindow.this.m_thresholdTextField.setValue(String.valueOf(threshold.getThreshold()));
                    return null;
                }

                public Void visit(ExponentialPropagation exponentialPropagation) {
                    BusinessServiceEditWindow.this.m_exponentialPropagationBaseTextField.setValue(String.valueOf(exponentialPropagation.getBase()));
                    return null;
                }
            });
        }
        this.m_edgesListSelect = new ListSelect("Edges");
        this.m_edgesListSelect.setId("edgeList");
        this.m_edgesListSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_edgesListSelect.setRows(10);
        this.m_edgesListSelect.setNullSelectionAllowed(false);
        this.m_edgesListSelect.setMultiSelect(false);
        this.refreshEdges();
        HorizontalLayout edgesListAndButtonLayout = new HorizontalLayout();
        edgesListAndButtonLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        VerticalLayout edgesButtonLayout = new VerticalLayout();
        edgesButtonLayout.setWidth(110.0f, Sizeable.Unit.PIXELS);
        edgesButtonLayout.setSpacing(true);
        Button addEdgeButton = new Button("Add Edge");
        addEdgeButton.setId("addEdgeButton");
        addEdgeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        addEdgeButton.addStyleName("small");
        edgesButtonLayout.addComponent((Component)addEdgeButton);
        addEdgeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            BusinessServiceEdgeEditWindow window = new BusinessServiceEdgeEditWindow(businessService, businessServiceManager, null);
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.refreshEdges());
            this.getUI().addWindow((Window)window);
        });
        Button editEdgeButton = new Button("Edit Edge");
        editEdgeButton.setId("editEdgeButton");
        editEdgeButton.setEnabled(false);
        editEdgeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        editEdgeButton.addStyleName("small");
        edgesButtonLayout.addComponent((Component)editEdgeButton);
        editEdgeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            BusinessServiceEdgeEditWindow window = new BusinessServiceEdgeEditWindow(businessService, businessServiceManager, (Edge)this.m_edgesListSelect.getValue());
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.refreshEdges());
            this.getUI().addWindow((Window)window);
        });
        Button removeEdgeButton = new Button("Remove Edge");
        removeEdgeButton.setId("removeEdgeButton");
        removeEdgeButton.setEnabled(false);
        removeEdgeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        removeEdgeButton.addStyleName("small");
        edgesButtonLayout.addComponent((Component)removeEdgeButton);
        this.m_edgesListSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            removeEdgeButton.setEnabled(event.getProperty().getValue() != null);
            editEdgeButton.setEnabled(event.getProperty().getValue() != null);
        });
        removeEdgeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.m_edgesListSelect.getValue() != null) {
                removeEdgeButton.setEnabled(false);
                ((Edge)this.m_edgesListSelect.getValue()).delete();
                this.refreshEdges();
            }
        });
        edgesListAndButtonLayout.setSpacing(true);
        edgesListAndButtonLayout.addComponent((Component)this.m_edgesListSelect);
        edgesListAndButtonLayout.setExpandRatio((Component)this.m_edgesListSelect, 1.0f);
        edgesListAndButtonLayout.addComponent((Component)edgesButtonLayout);
        edgesListAndButtonLayout.setComponentAlignment((Component)edgesButtonLayout, Alignment.BOTTOM_CENTER);
        verticalLayout.addComponent((Component)edgesListAndButtonLayout);
        this.m_attributesListSelect = new ListSelect("Attributes");
        this.m_attributesListSelect.setId("attributeList");
        this.m_attributesListSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_attributesListSelect.setRows(10);
        this.m_attributesListSelect.setNullSelectionAllowed(false);
        this.m_attributesListSelect.setMultiSelect(false);
        this.refreshAttributes();
        HorizontalLayout attributesListAndButtonLayout = new HorizontalLayout();
        attributesListAndButtonLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        VerticalLayout attributesButtonLayout = new VerticalLayout();
        attributesButtonLayout.setWidth(110.0f, Sizeable.Unit.PIXELS);
        attributesButtonLayout.setSpacing(true);
        Button addAttributeButton = new Button("Add Attribute");
        addAttributeButton.setId("addAttributeButton");
        addAttributeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        addAttributeButton.addStyleName("small");
        attributesButtonLayout.addComponent((Component)addAttributeButton);
        addAttributeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            KeyValueInputDialogWindow keyValueInputDialogWindow = new KeyValueInputDialogWindow().withKeyFieldName("Key").withValueFieldName("Value").withCaption("Attribute").withKey("").withValue("").withOkAction(new KeyValueInputDialogWindow.Action(){

                public void execute(KeyValueInputDialogWindow window) {
                    BusinessServiceEditWindow.this.m_businessService.getAttributes().put(window.getKey(), window.getValue());
                    BusinessServiceEditWindow.this.refreshAttributes();
                }
            }).withKeyValidator((Validator)new AbstractStringValidator("Key must not be empty"){
                private static final long serialVersionUID = 1L;

                protected boolean isValidValue(String value) {
                    return !Strings.isNullOrEmpty((String)value);
                }
            }).withKeyValidator((Validator)new AbstractStringValidator("Key must be unique"){
                private static final long serialVersionUID = 1L;

                protected boolean isValidValue(String value) {
                    return !BusinessServiceEditWindow.this.m_businessService.getAttributes().containsKey(value);
                }
            }).focusKey();
            this.getUI().addWindow((Window)keyValueInputDialogWindow);
            keyValueInputDialogWindow.focus();
        });
        Button editAttributeButton = new Button("Edit Attribute");
        editAttributeButton.setId("editAttributeButton");
        editAttributeButton.setEnabled(false);
        editAttributeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        editAttributeButton.addStyleName("small");
        attributesButtonLayout.addComponent((Component)editAttributeButton);
        editAttributeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            Map.Entry entry = (Map.Entry)this.m_attributesListSelect.getValue();
            KeyValueInputDialogWindow keyValueInputDialogWindow = new KeyValueInputDialogWindow().withKeyFieldName("Key").withValueFieldName("Value").withCaption("Attribute").withKey((String)entry.getKey()).disableKey().withValue((String)entry.getValue()).withOkAction(new KeyValueInputDialogWindow.Action(){

                public void execute(KeyValueInputDialogWindow window) {
                    BusinessServiceEditWindow.this.m_businessService.getAttributes().put(window.getKey(), window.getValue());
                    BusinessServiceEditWindow.this.refreshAttributes();
                }
            }).focusValue();
            this.getUI().addWindow((Window)keyValueInputDialogWindow);
            keyValueInputDialogWindow.focus();
        });
        Button removeAttributeButton = new Button("Remove Attribute");
        removeAttributeButton.setId("removeAttributeButton");
        removeAttributeButton.setEnabled(false);
        removeAttributeButton.setWidth(110.0f, Sizeable.Unit.PIXELS);
        removeAttributeButton.addStyleName("small");
        attributesButtonLayout.addComponent((Component)removeAttributeButton);
        this.m_attributesListSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            removeAttributeButton.setEnabled(event.getProperty().getValue() != null);
            editAttributeButton.setEnabled(event.getProperty().getValue() != null);
        });
        removeAttributeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.m_attributesListSelect.getValue() != null) {
                removeAttributeButton.setEnabled(false);
                this.m_businessService.getAttributes().remove(((Map.Entry)this.m_attributesListSelect.getValue()).getKey());
                this.refreshAttributes();
            }
        });
        attributesListAndButtonLayout.setSpacing(true);
        attributesListAndButtonLayout.addComponent((Component)this.m_attributesListSelect);
        attributesListAndButtonLayout.setExpandRatio((Component)this.m_attributesListSelect, 1.0f);
        attributesListAndButtonLayout.addComponent((Component)attributesButtonLayout);
        attributesListAndButtonLayout.setComponentAlignment((Component)attributesButtonLayout, Alignment.BOTTOM_CENTER);
        verticalLayout.addComponent((Component)attributesListAndButtonLayout);
        verticalLayout.addComponent((Component)buttonLayout);
        verticalLayout.setExpandRatio((Component)buttonLayout, 1.0f);
        verticalLayout.setComponentAlignment((Component)buttonLayout, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)verticalLayout);
    }

    private void setVisible(Field<?> field, boolean visible) {
        field.setEnabled(visible);
        field.setRequired(visible);
        field.setVisible(visible);
    }

    private void refreshAttributes() {
        this.m_attributesListSelect.removeAllItems();
        this.m_attributesListSelect.addItems((Collection)this.m_businessService.getAttributes().entrySet().stream().sorted(Ordering.natural().onResultOf(Map.Entry::getKey)).collect(Collectors.toList()));
        this.m_attributesListSelect.getItemIds().forEach(item -> this.m_attributesListSelect.setItemCaption(item, (String)((Map.Entry)item).getKey() + "=" + (String)((Map.Entry)item).getValue()));
    }

    private void refreshEdges() {
        this.m_edgesListSelect.removeAllItems();
        this.m_edgesListSelect.addItems((Collection)this.m_businessService.getEdges().stream().map(e -> e).sorted((e1, e2) -> BusinessServiceEditWindow.getChildDescription(e1).compareTo(BusinessServiceEditWindow.getChildDescription(e2))).collect(Collectors.toList()));
        this.m_edgesListSelect.getItemIds().forEach(item -> this.m_edgesListSelect.setItemCaption(item, BusinessServiceEditWindow.describeEdge((Edge)item)));
    }

    public static String describeBusinessService(BusinessService businessService) {
        return businessService.getName();
    }

    public static String describeApplication(Application application) {
        return application.getApplicationName();
    }

    public static String describeIpService(IpService ipService) {
        return BusinessServiceEditWindow.describeIpService(ipService, null);
    }

    public static String describeIpService(IpService ipService, String friendlyName) {
        return String.format("%s %s %s%s", ipService.getNodeLabel(), ipService.getIpAddress(), ipService.getServiceName(), Strings.isNullOrEmpty((String)friendlyName) ? "" : " (" + friendlyName + ")");
    }

    private static String getEdgePrefix(Edge edge) {
        return (String)edge.accept((EdgeVisitor)new EdgeVisitor<String>(){

            public String visit(IpServiceEdge edge) {
                return "IPSvc";
            }

            public String visit(ReductionKeyEdge edge) {
                return "ReKey";
            }

            public String visit(ChildEdge edge) {
                return "Child";
            }

            public String visit(ApplicationEdge edge) {
                return "Application";
            }
        });
    }

    private static String getChildDescription(Edge edge) {
        return (String)edge.accept((EdgeVisitor)new EdgeVisitor<String>(){

            public String visit(IpServiceEdge edge) {
                return BusinessServiceEditWindow.describeIpService(edge.getIpService(), edge.getFriendlyName());
            }

            public String visit(ReductionKeyEdge edge) {
                return BusinessServiceEditWindow.describeReductionKey(edge.getReductionKey(), edge.getFriendlyName());
            }

            public String visit(ChildEdge edge) {
                return BusinessServiceEditWindow.describeBusinessService(edge.getChild());
            }

            public String visit(ApplicationEdge edge) {
                return BusinessServiceEditWindow.describeApplication(edge.getApplication());
            }
        });
    }

    public static String describeReductionKey(String reductionKey, String friendlyName) {
        return reductionKey + (Strings.isNullOrEmpty((String)friendlyName) ? "" : " (" + friendlyName + ")");
    }

    public static String describeEdge(Edge edge) {
        String edgePrefix = BusinessServiceEditWindow.getEdgePrefix(edge);
        String itemDescription = BusinessServiceEditWindow.getChildDescription(edge);
        return String.format("%s: %s, Map: %s, Weight: %s", edgePrefix, itemDescription, edge.getMapFunction().getClass() == SetTo.class ? String.format("%s (%s)", edge.getMapFunction().getClass().getSimpleName(), ((SetTo)edge.getMapFunction()).getStatus()) : edge.getMapFunction().getClass().getSimpleName(), edge.getWeight());
    }
}

