/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ApplicationEdge;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.EdgeVisitor;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.Decrease;
import org.opennms.netmgt.bsm.service.model.functions.map.Identity;
import org.opennms.netmgt.bsm.service.model.functions.map.Ignore;
import org.opennms.netmgt.bsm.service.model.functions.map.Increase;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.map.SetTo;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEditWindow;
import org.opennms.netmgt.vaadin.core.TransactionAwareUI;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceEdgeEditWindow
extends Window {
    private static final long serialVersionUID = -5780075265758041282L;
    private static int FRIENDLY_NAME_MAXLENGTH = 30;
    private final NativeSelect m_typeSelect;
    private final ComboBox m_childServiceComponent;
    private final ComboBox m_ipServiceComponent;
    private final ComboBox m_applicationComponent;
    private final TextField m_reductionKeyComponent;
    private final NativeSelect m_mapFunctionSelect;
    private final NativeSelect m_mapFunctionSeveritySelect;
    private final TextField m_weightField;
    private final TextField m_friendlyNameField;

    public BusinessServiceEdgeEditWindow(BusinessService businessService, BusinessServiceManager businessServiceManager, final Edge edge) {
        super("Business Service Edge Edit");
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        this.setWidth(650.0f, Sizeable.Unit.PIXELS);
        this.setHeight(325.0f, Sizeable.Unit.PIXELS);
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSpacing(true);
        rootLayout.setMargin(false);
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(true);
        formLayout.setMargin(true);
        this.m_typeSelect = new NativeSelect("Type");
        this.m_typeSelect.setId("edgeTypeSelector");
        this.m_typeSelect.setMultiSelect(false);
        this.m_typeSelect.setNewItemsAllowed(false);
        this.m_typeSelect.setNullSelectionAllowed(false);
        this.m_typeSelect.setRequired(true);
        this.m_typeSelect.addItem((Object)EdgeType.CHILD_SERVICE);
        this.m_typeSelect.setItemCaption((Object)EdgeType.CHILD_SERVICE, "Child Service");
        this.m_typeSelect.addItem((Object)EdgeType.IP_SERVICE);
        this.m_typeSelect.setItemCaption((Object)EdgeType.IP_SERVICE, "IP Service");
        this.m_typeSelect.addItem((Object)EdgeType.REDUCTION_KEY);
        this.m_typeSelect.setItemCaption((Object)EdgeType.REDUCTION_KEY, "Reduction Key");
        this.m_typeSelect.addItem((Object)EdgeType.APPLICATION);
        this.m_typeSelect.setItemCaption((Object)EdgeType.APPLICATION, "Application");
        this.m_typeSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        formLayout.addComponent((Component)this.m_typeSelect);
        this.m_childServiceComponent = new ComboBox("Child Service");
        this.m_childServiceComponent.setId("childServiceList");
        this.m_childServiceComponent.setInputPrompt("No child service selected");
        this.m_childServiceComponent.setNewItemsAllowed(false);
        this.m_childServiceComponent.setNullSelectionAllowed(false);
        this.m_childServiceComponent.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_childServiceComponent.setVisible(false);
        this.m_childServiceComponent.setImmediate(true);
        this.m_childServiceComponent.setValidationVisible(true);
        this.m_childServiceComponent.setFilteringMode(FilteringMode.CONTAINS);
        this.m_childServiceComponent.addItems((Collection)businessServiceManager.getFeasibleChildServices(businessService).stream().sorted(Ordering.natural().onResultOf(BusinessServiceEditWindow::describeBusinessService)).collect(Collectors.toList()));
        this.m_childServiceComponent.getItemIds().forEach(item -> this.m_childServiceComponent.setItemCaption(item, BusinessServiceEditWindow.describeBusinessService((BusinessService)item)));
        formLayout.addComponent((Component)this.m_childServiceComponent);
        this.m_ipServiceComponent = new ComboBox("IP Service");
        this.m_ipServiceComponent.setId("ipServiceList");
        this.m_ipServiceComponent.setInputPrompt("No IP service selected");
        this.m_ipServiceComponent.setNewItemsAllowed(false);
        this.m_ipServiceComponent.setNullSelectionAllowed(false);
        this.m_ipServiceComponent.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_ipServiceComponent.setVisible(false);
        this.m_ipServiceComponent.setImmediate(true);
        this.m_ipServiceComponent.setValidationVisible(true);
        this.m_ipServiceComponent.setFilteringMode(FilteringMode.CONTAINS);
        this.m_ipServiceComponent.addItems((Collection)businessServiceManager.getAllIpServices().stream().sorted(Ordering.natural().onResultOf(BusinessServiceEditWindow::describeIpService)).collect(Collectors.toList()));
        this.m_ipServiceComponent.getItemIds().forEach(item -> this.m_ipServiceComponent.setItemCaption(item, BusinessServiceEditWindow.describeIpService((IpService)item)));
        formLayout.addComponent((Component)this.m_ipServiceComponent);
        this.m_applicationComponent = new ComboBox("Application");
        this.m_applicationComponent.setId("applicationList");
        this.m_applicationComponent.setInputPrompt("No Application selected");
        this.m_applicationComponent.setNewItemsAllowed(false);
        this.m_applicationComponent.setNullSelectionAllowed(false);
        this.m_applicationComponent.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_applicationComponent.setVisible(false);
        this.m_applicationComponent.setImmediate(true);
        this.m_applicationComponent.setValidationVisible(true);
        this.m_applicationComponent.setFilteringMode(FilteringMode.CONTAINS);
        this.m_applicationComponent.addItems((Collection)businessServiceManager.getAllApplications().stream().sorted(Ordering.natural().onResultOf(BusinessServiceEditWindow::describeApplication)).collect(Collectors.toList()));
        this.m_applicationComponent.getItemIds().forEach(item -> this.m_applicationComponent.setItemCaption(item, BusinessServiceEditWindow.describeApplication((Application)item)));
        formLayout.addComponent((Component)this.m_applicationComponent);
        this.m_reductionKeyComponent = new TextField("Reduction Key");
        this.m_reductionKeyComponent.setId("reductionKeyField");
        this.m_reductionKeyComponent.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_reductionKeyComponent.setVisible(false);
        this.m_reductionKeyComponent.setImmediate(true);
        this.m_reductionKeyComponent.setValidationVisible(true);
        formLayout.addComponent((Component)this.m_reductionKeyComponent);
        this.m_friendlyNameField = new TextField("Friendly Name");
        this.m_friendlyNameField.setId("friendlyNameField");
        this.m_friendlyNameField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_friendlyNameField.setVisible(false);
        this.m_friendlyNameField.setImmediate(true);
        this.m_friendlyNameField.setValidationVisible(true);
        this.m_friendlyNameField.setNullSettingAllowed(true);
        this.m_friendlyNameField.setNullRepresentation("");
        this.m_friendlyNameField.setMaxLength(FRIENDLY_NAME_MAXLENGTH);
        formLayout.addComponent((Component)this.m_friendlyNameField);
        this.m_typeSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.m_childServiceComponent.setVisible(this.m_typeSelect.getValue() == EdgeType.CHILD_SERVICE);
            this.m_childServiceComponent.setRequired(this.m_typeSelect.getValue() == EdgeType.CHILD_SERVICE);
            this.m_ipServiceComponent.setVisible(this.m_typeSelect.getValue() == EdgeType.IP_SERVICE);
            this.m_ipServiceComponent.setRequired(this.m_typeSelect.getValue() == EdgeType.IP_SERVICE);
            this.m_reductionKeyComponent.setVisible(this.m_typeSelect.getValue() == EdgeType.REDUCTION_KEY);
            this.m_reductionKeyComponent.setRequired(this.m_typeSelect.getValue() == EdgeType.REDUCTION_KEY);
            this.m_applicationComponent.setVisible(this.m_typeSelect.getValue() == EdgeType.APPLICATION);
            this.m_applicationComponent.setRequired(this.m_typeSelect.getValue() == EdgeType.APPLICATION);
            this.m_friendlyNameField.setVisible(this.m_typeSelect.getValue() == EdgeType.REDUCTION_KEY || this.m_typeSelect.getValue() == EdgeType.IP_SERVICE);
        });
        this.m_mapFunctionSelect = new NativeSelect("Map Function", (Collection)ImmutableList.builder().add(Decrease.class).add(Identity.class).add(Ignore.class).add(Increase.class).add(SetTo.class).build());
        this.m_mapFunctionSelect.setId("mapFunctionSelector");
        this.m_mapFunctionSelect.setNullSelectionAllowed(false);
        this.m_mapFunctionSelect.setMultiSelect(false);
        this.m_mapFunctionSelect.setNewItemsAllowed(false);
        this.m_mapFunctionSelect.setRequired(true);
        this.m_mapFunctionSelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_mapFunctionSelect.getItemIds().forEach(itemId -> this.m_mapFunctionSelect.setItemCaption(itemId, ((Class)itemId).getSimpleName()));
        formLayout.addComponent((Component)this.m_mapFunctionSelect);
        this.m_mapFunctionSeveritySelect = new NativeSelect("Severity");
        this.m_mapFunctionSeveritySelect.setMultiSelect(false);
        this.m_mapFunctionSeveritySelect.setNewItemsAllowed(false);
        this.m_mapFunctionSeveritySelect.setNullSelectionAllowed(false);
        this.m_mapFunctionSeveritySelect.setRequired(false);
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.CRITICAL);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.CRITICAL, "Critical");
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.MAJOR);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.MAJOR, "Major");
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.MINOR);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.MINOR, "Minor");
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.WARNING);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.WARNING, "Warning");
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.NORMAL);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.NORMAL, "Normal");
        this.m_mapFunctionSeveritySelect.addItem((Object)Status.INDETERMINATE);
        this.m_mapFunctionSeveritySelect.setItemCaption((Object)Status.INDETERMINATE, "Indeterminate");
        this.m_mapFunctionSeveritySelect.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_mapFunctionSeveritySelect.setEnabled(false);
        this.m_mapFunctionSeveritySelect.setImmediate(true);
        this.m_mapFunctionSeveritySelect.setValidationVisible(true);
        formLayout.addComponent((Component)this.m_mapFunctionSeveritySelect);
        this.m_mapFunctionSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.m_mapFunctionSeveritySelect.setEnabled(SetTo.class.equals(this.m_mapFunctionSelect.getValue()));
            this.m_mapFunctionSeveritySelect.setRequired(SetTo.class.equals(this.m_mapFunctionSelect.getValue()));
        });
        this.m_weightField = new TextField("Weight");
        this.m_weightField.setId("weightField");
        this.m_weightField.setRequired(true);
        this.m_weightField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_weightField.addValidator((Validator & Serializable)value -> {
            try {
                int intValue = Integer.parseInt((String)value);
                if (intValue <= 0) {
                    throw new Validator.InvalidValueException("Weight must be > 0");
                }
            }
            catch (NumberFormatException e) {
                throw new Validator.InvalidValueException("Weight must be a number");
            }
        });
        this.m_weightField.setImmediate(true);
        this.m_weightField.setValidationVisible(true);
        formLayout.addComponent((Component)this.m_weightField);
        this.m_typeSelect.setValue((Object)EdgeType.CHILD_SERVICE);
        this.m_mapFunctionSelect.setValue(Identity.class);
        this.m_mapFunctionSeveritySelect.setValue((Object)Status.INDETERMINATE);
        this.m_weightField.setValue(Integer.toString(1));
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        buttonLayout.setMargin(true);
        Button saveButton = new Button(edge == null ? "Add Edge" : "Update Edge");
        saveButton.setId("saveEdgeButton");
        saveButton.addClickListener((Button.ClickListener)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Button.ClickListener & Serializable)event -> {
            if (!this.m_weightField.isValid()) {
                return;
            }
            if (!this.m_ipServiceComponent.isValid()) {
                return;
            }
            if (!this.m_childServiceComponent.isValid()) {
                return;
            }
            if (!this.m_reductionKeyComponent.isValid()) {
                return;
            }
            MapFunction mapFunction = this.getMapFunction();
            int weight = Integer.parseInt((String)this.m_weightField.getValue());
            if (edge != null) {
                businessService.removeEdge(edge);
            }
            switch ((EdgeType)((Object)((Object)this.m_typeSelect.getValue()))) {
                case CHILD_SERVICE: {
                    businessService.addChildEdge((BusinessService)this.m_childServiceComponent.getValue(), mapFunction, weight);
                    break;
                }
                case IP_SERVICE: {
                    businessService.addIpServiceEdge((IpService)this.m_ipServiceComponent.getValue(), mapFunction, weight, (String)this.m_friendlyNameField.getValue());
                    break;
                }
                case REDUCTION_KEY: {
                    businessService.addReductionKeyEdge((String)this.m_reductionKeyComponent.getValue(), mapFunction, weight, (String)this.m_friendlyNameField.getValue());
                    break;
                }
                case APPLICATION: {
                    businessService.addApplicationEdge((Application)this.m_applicationComponent.getValue(), mapFunction, weight);
                }
            }
            this.close();
        }));
        buttonLayout.addComponent((Component)saveButton);
        Button cancelButton = new Button("Cancel");
        cancelButton.setId("cancelEdgeButton");
        cancelButton.addClickListener((Button.ClickListener & Serializable)event -> this.close());
        buttonLayout.addComponent((Component)cancelButton);
        if (edge != null) {
            edge.accept((EdgeVisitor)new EdgeVisitor<Void>(){

                public Void visit(IpServiceEdge edge) {
                    BusinessServiceEdgeEditWindow.this.m_typeSelect.setValue((Object)EdgeType.IP_SERVICE);
                    for (IpService ipService : BusinessServiceEdgeEditWindow.this.m_ipServiceComponent.getItemIds()) {
                        if (ipService.getId() != edge.getIpService().getId()) continue;
                        BusinessServiceEdgeEditWindow.this.m_ipServiceComponent.setValue((Object)ipService);
                        break;
                    }
                    BusinessServiceEdgeEditWindow.this.m_friendlyNameField.setValue(edge.getFriendlyName());
                    BusinessServiceEdgeEditWindow.this.m_ipServiceComponent.setEnabled(false);
                    return null;
                }

                public Void visit(ReductionKeyEdge edge) {
                    BusinessServiceEdgeEditWindow.this.m_typeSelect.setValue((Object)EdgeType.REDUCTION_KEY);
                    BusinessServiceEdgeEditWindow.this.m_reductionKeyComponent.setValue(edge.getReductionKey());
                    BusinessServiceEdgeEditWindow.this.m_friendlyNameField.setValue(edge.getFriendlyName());
                    BusinessServiceEdgeEditWindow.this.m_reductionKeyComponent.setEnabled(false);
                    return null;
                }

                public Void visit(ChildEdge edge) {
                    BusinessServiceEdgeEditWindow.this.m_typeSelect.setValue((Object)EdgeType.CHILD_SERVICE);
                    BusinessServiceEdgeEditWindow.this.m_childServiceComponent.setValue((Object)edge.getChild());
                    BusinessServiceEdgeEditWindow.this.m_childServiceComponent.setEnabled(false);
                    return null;
                }

                public Void visit(ApplicationEdge edge) {
                    BusinessServiceEdgeEditWindow.this.m_typeSelect.setValue((Object)EdgeType.APPLICATION);
                    BusinessServiceEdgeEditWindow.this.m_friendlyNameField.setValue(edge.getFriendlyName());
                    BusinessServiceEdgeEditWindow.this.m_ipServiceComponent.setEnabled(false);
                    return null;
                }
            });
            this.m_typeSelect.setEnabled(false);
            this.m_mapFunctionSelect.setValue(edge.getMapFunction().getClass());
            edge.getMapFunction().accept((MapFunctionVisitor)new MapFunctionVisitor<Void>(){

                public Void visit(Decrease decrease) {
                    BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.setValue((Object)Status.INDETERMINATE);
                    return null;
                }

                public Void visit(Identity identity) {
                    BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.setValue((Object)Status.INDETERMINATE);
                    return null;
                }

                public Void visit(Ignore ignore) {
                    BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.setValue((Object)Status.INDETERMINATE);
                    return null;
                }

                public Void visit(Increase increase) {
                    BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.setValue((Object)Status.INDETERMINATE);
                    return null;
                }

                public Void visit(SetTo setTo) {
                    BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.setValue((Object)((SetTo)edge.getMapFunction()).getStatus());
                    return null;
                }
            });
            this.m_weightField.setValue(String.valueOf(edge.getWeight()));
        }
        rootLayout.addComponent((Component)formLayout);
        rootLayout.addComponent((Component)buttonLayout);
        rootLayout.setComponentAlignment((Component)buttonLayout, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)rootLayout);
    }

    private MapFunction getMapFunction() {
        try {
            MapFunction mapFunction = (MapFunction)((Class)this.m_mapFunctionSelect.getValue()).newInstance();
            mapFunction.accept((MapFunctionVisitor)new MapFunctionVisitor<Void>(){

                public Void visit(Decrease decrease) {
                    return null;
                }

                public Void visit(Identity identity) {
                    return null;
                }

                public Void visit(Ignore ignore) {
                    return null;
                }

                public Void visit(Increase increase) {
                    return null;
                }

                public Void visit(SetTo setTo) {
                    setTo.setStatus((Status)BusinessServiceEdgeEditWindow.this.m_mapFunctionSeveritySelect.getValue());
                    return null;
                }
            });
            return mapFunction;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static enum EdgeType {
        IP_SERVICE,
        REDUCTION_KEY,
        CHILD_SERVICE,
        APPLICATION;

    }
}

