/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.ContainerHierarchicalWrapper;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Table;
import com.vaadin.ui.TreeTable;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.features.topology.link.Layout;
import org.opennms.features.topology.link.TopologyLinkBuilder;
import org.opennms.features.topology.link.TopologyProvider;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceContainer;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEditWindow;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceFilter;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceRow;
import org.opennms.netmgt.vaadin.core.ConfirmationDialog;
import org.opennms.netmgt.vaadin.core.TransactionAwareUI;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceTreeTable
extends TreeTable {
    private final BusinessServiceManager businessServiceManager;
    private String businessServiceNameFilter = null;

    public BusinessServiceTreeTable(final BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
        this.setSizeFull();
        this.setContainerDataSource((Container)new BusinessServiceContainer());
        this.addGeneratedColumn("links", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 7113848887128656685L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                BusinessService businessService;
                HorizontalLayout layout = new HorizontalLayout();
                BusinessServiceStateMachine stateMachine = businessServiceManager.getStateMachine();
                Status status = stateMachine.getOperationalStatus(businessService = ((BusinessServiceRow)BusinessServiceTreeTable.this.getItem(itemId).getBean()).getBusinessService());
                if (status != null) {
                    String topologyLink = new TopologyLinkBuilder().focus(new String[]{businessService.getId().toString()}).szl(1).layout(Layout.HIERARCHY).provider(TopologyProvider.BUSINESS_SERVICE).getLink();
                    Link link = new Link("View in Topology UI", (Resource)new ExternalResource(topologyLink));
                    link.setIcon((Resource)FontAwesome.EXTERNAL_LINK_SQUARE);
                    link.setTargetName("_blank");
                    layout.addComponent((Component)link);
                    layout.setComponentAlignment((Component)link, Alignment.MIDDLE_CENTER);
                } else {
                    Label label = new Label("N/A");
                    label.setDescription("Try reloading the daemon and refreshing the table.");
                    label.setWidth(null);
                    layout.addComponent((Component)label);
                }
                return layout;
            }
        });
        this.addGeneratedColumn("edit / delete", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 7113848887128656685L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                HorizontalLayout layout = new HorizontalLayout();
                layout.setSpacing(true);
                Button editButton = new Button("Edit", (Resource)FontAwesome.PENCIL_SQUARE_O);
                editButton.setId("editButton-" + ((BusinessServiceRow)BusinessServiceTreeTable.this.getItem(itemId).getBean()).getName());
                editButton.addClickListener((Button.ClickListener)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Button.ClickListener & Serializable)event -> {
                    BusinessServiceEditWindow window = new BusinessServiceEditWindow(((BusinessServiceRow)BusinessServiceTreeTable.this.getItem(itemId).getBean()).getBusinessService(), businessServiceManager);
                    window.addCloseListener((Window.CloseListener & Serializable)e -> BusinessServiceTreeTable.this.refresh());
                    BusinessServiceTreeTable.this.getUI().addWindow((Window)window);
                }));
                layout.addComponent((Component)editButton);
                Button deleteButton = new Button("Delete", (Resource)FontAwesome.TRASH_O);
                deleteButton.setId("deleteButton-" + ((BusinessServiceRow)BusinessServiceTreeTable.this.getItem(itemId).getBean()).getName());
                deleteButton.addClickListener((Button.ClickListener & Serializable)event -> {
                    final BusinessService businessService = ((BusinessServiceRow)BusinessServiceTreeTable.this.getItem(itemId).getBean()).getBusinessService();
                    if (businessService.getParentServices().isEmpty() && businessService.getChildEdges().isEmpty()) {
                        ((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).runInTransaction(() -> {
                            businessServiceManager.getBusinessServiceById(businessService.getId()).delete();
                            BusinessServiceTreeTable.this.refresh();
                        });
                    } else {
                        new ConfirmationDialog().withOkAction((ConfirmationDialog.Action)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Object)new ConfirmationDialog.Action(){

                            public void execute(ConfirmationDialog window) {
                                businessServiceManager.getBusinessServiceById(businessService.getId()).delete();
                                BusinessServiceTreeTable.this.refresh();
                            }
                        })).withOkLabel("Delete anyway").withCancelLabel("Cancel").withCaption("Warning").withDescription("This entry is referencing or is referenced by other Business Services! Do you really want to delete this entry?").open();
                    }
                });
                layout.addComponent((Component)deleteButton);
                return layout;
            }
        });
        this.setColumnExpandRatio("name", 5.0f);
        this.setColumnExpandRatio("links", 1.0f);
        this.setColumnExpandRatio("edit / delete", 1.0f);
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){

            public String getStyle(Table source, Object itemId, Object propertyId) {
                String value;
                Property property;
                Item item;
                if (!Strings.isNullOrEmpty((String)BusinessServiceTreeTable.this.businessServiceNameFilter) && source != null && itemId != null && "name".equals(propertyId) && (item = source.getItem(itemId)) != null && (property = item.getItemProperty((Object)"name")) != null && property.getValue() != null && !(value = property.getValue().toString()).toLowerCase().contains(BusinessServiceTreeTable.this.businessServiceNameFilter)) {
                    return "grey";
                }
                return null;
            }
        });
    }

    public BeanItem<BusinessServiceRow> getItem(Object itemId) {
        return (BeanItem)super.getItem(itemId);
    }

    public void setBusinessServiceNameFilter(String businessServiceNameFilter) {
        this.businessServiceNameFilter = businessServiceNameFilter == null ? "" : businessServiceNameFilter.toLowerCase();
        this.refresh();
    }

    public void expandForBusinessServiceNameFilter() {
        if (Strings.isNullOrEmpty((String)this.businessServiceNameFilter)) {
            return;
        }
        for (Object itemId : this.getItemIds()) {
            this.expandSuccessorsForBusinessServiceNameFilter(itemId);
        }
    }

    private void expandSuccessorsForBusinessServiceNameFilter(Object itemId) {
        if (itemId == null) {
            return;
        }
        if (((BusinessServiceRow)this.getItem(itemId).getBean()).getName().toLowerCase().contains(this.businessServiceNameFilter)) {
            this.setCollapsed(itemId, true);
            return;
        }
        this.setCollapsed(itemId, false);
        Collection children = this.getChildren(itemId);
        if (children != null) {
            for (Object childItemId : children) {
                this.expandSuccessorsForBusinessServiceNameFilter(childItemId);
            }
        }
    }

    public void refresh() {
        com.google.common.collect.Table<Long, Optional<Long>, Boolean> expandState = this.getCurrentExpandState();
        BusinessServiceContainer newContainer = new BusinessServiceContainer();
        if (!Strings.isNullOrEmpty((String)this.businessServiceNameFilter)) {
            newContainer.addContainerFilter(new BusinessServiceFilter(newContainer, this.businessServiceNameFilter));
        }
        List allBusinessServices = this.businessServiceManager.getAllBusinessServices();
        BusinessServiceGraph graph = this.businessServiceManager.getGraph(allBusinessServices);
        graph.getVerticesByLevel(0).stream().filter(v -> v.getBusinessService() != null).sorted((v1, v2) -> v1.getBusinessService().getName().compareTo(v2.getBusinessService().getName())).forEach(v -> newContainer.addRow(graph, (GraphVertex)v));
        Container.Hierarchical hierarchicalContainer = BusinessServiceTreeTable.createHierarchicalContainer(newContainer);
        this.setContainerDataSource((Container)hierarchicalContainer);
        this.setVisibleColumns(new Object[]{"name", "links", "edit / delete"});
        List<BusinessServiceRow> rows = this.getItemIds().stream().map(itemId -> (BusinessServiceRow)this.getItem(itemId).getBean()).collect(Collectors.toList());
        this.applyExpandState(expandState, rows);
    }

    private void applyExpandState(com.google.common.collect.Table<Long, Optional<Long>, Boolean> collapseState, List<BusinessServiceRow> rows) {
        for (BusinessServiceRow row : rows) {
            Boolean wasCollapsed = (Boolean)collapseState.get((Object)row.getBusinessService().getId(), Optional.ofNullable(row.getParentBusinessServiceId()));
            this.setCollapsed(row.getRowId(), wasCollapsed != null ? wasCollapsed : true);
            if (!this.hasChildren(row.getRowId())) continue;
            this.applyExpandState(collapseState, this.getChildren(row.getRowId()).stream().map(itemId -> (BusinessServiceRow)this.getItem(itemId).getBean()).collect(Collectors.toList()));
        }
    }

    private com.google.common.collect.Table<Long, Optional<Long>, Boolean> getCurrentExpandState() {
        HashBasedTable collapseState = HashBasedTable.create();
        for (Object itemId : this.getItemIds()) {
            BusinessServiceRow row = (BusinessServiceRow)this.getItem(itemId).getBean();
            collapseState.put((Object)row.getBusinessService().getId(), Optional.ofNullable(row.getParentBusinessServiceId()), (Object)this.isCollapsed(itemId));
        }
        return collapseState;
    }

    private static Container.Hierarchical createHierarchicalContainer(BusinessServiceContainer newContainer) {
        ContainerHierarchicalWrapper hierarchicalContainer = new ContainerHierarchicalWrapper((Container)newContainer);
        for (Map.Entry<Long, Long> eachEntry : newContainer.getRowIdToParentRowIdMapping().entrySet()) {
            hierarchicalContainer.setParent((Object)eachEntry.getKey(), (Object)eachEntry.getValue());
        }
        for (Map.Entry<Long, Long> itemId : hierarchicalContainer.getItemIds()) {
            hierarchicalContainer.setChildrenAllowed(itemId, hierarchicalContainer.hasChildren(itemId));
        }
        return hierarchicalContainer;
    }
}

