/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Objects;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEditWindow;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceTreeTable;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceMainLayout
extends VerticalLayout {
    private static final long serialVersionUID = -6753816061488048389L;
    private final BusinessServiceManager m_businessServiceManager;
    private final BusinessServiceTreeTable m_table;

    public BusinessServiceMainLayout(BusinessServiceManager businessServiceManager) {
        this.m_businessServiceManager = Objects.requireNonNull(businessServiceManager);
        this.m_table = new BusinessServiceTreeTable(businessServiceManager);
        this.setSizeFull();
        Button createButton = UIHelper.createButton((String)"New Business Service", null, (Resource)FontAwesome.PLUS_SQUARE, (Button.ClickListener & Serializable)event -> {
            BusinessService businessService = this.m_businessServiceManager.createBusinessService();
            BusinessServiceEditWindow window = new BusinessServiceEditWindow(businessService, this.m_businessServiceManager);
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.m_table.refresh());
            this.getUI().addWindow((Window)window);
        });
        createButton.setId("createButton");
        Button collapseButton = UIHelper.createButton((String)"Collapse All", null, (Resource)FontAwesome.FOLDER, (Button.ClickListener & Serializable)event -> this.m_table.getContainerDataSource().getItemIds().forEach(id -> this.m_table.setCollapsed(id, true)));
        collapseButton.setId("collapseButton");
        Button expandButton = UIHelper.createButton((String)"Expand All", null, (Resource)FontAwesome.FOLDER_OPEN, (Button.ClickListener & Serializable)event -> this.m_table.getContainerDataSource().getItemIds().forEach(id -> this.m_table.setCollapsed(id, false)));
        expandButton.setId("expandButton");
        TextField filterTextField = new TextField();
        filterTextField.setInputPrompt("Filter");
        filterTextField.setId("filterTextField");
        filterTextField.setImmediate(true);
        filterTextField.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent textChangeEvent) {
                BusinessServiceMainLayout.this.m_table.setBusinessServiceNameFilter(textChangeEvent.getText());
                BusinessServiceMainLayout.this.m_table.expandForBusinessServiceNameFilter();
            }
        });
        Button clearFilterButton = UIHelper.createButton((String)"Clear Filter", null, (Resource)FontAwesome.TIMES_CIRCLE, (Button.ClickListener & Serializable)event -> {
            filterTextField.setValue("");
            this.m_table.setBusinessServiceNameFilter(null);
            this.m_table.getContainerDataSource().getItemIds().forEach(id -> this.m_table.setCollapsed(id, true));
        });
        clearFilterButton.setId("clearButton");
        Button refreshButton = UIHelper.createButton((String)"Refresh Table", null, (Resource)FontAwesome.REFRESH, (Button.ClickListener & Serializable)event -> this.m_table.refresh());
        refreshButton.setId("refreshButton");
        Button reloadButton = UIHelper.createButton((String)"Reload Daemon", (String)"Reloads the Business Service State Machine", (Resource)FontAwesome.RETWEET, (Button.ClickListener & Serializable)event -> {
            this.m_businessServiceManager.triggerDaemonReload();
            Notification.show((String)"Reloading", (String)"Business Service daemon is being reloaded.", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
        });
        reloadButton.setId("reloadButton");
        HorizontalLayout leftButtonGroup = new HorizontalLayout();
        leftButtonGroup.setSpacing(true);
        leftButtonGroup.addComponent((Component)createButton);
        leftButtonGroup.addComponent((Component)collapseButton);
        leftButtonGroup.addComponent((Component)expandButton);
        leftButtonGroup.setDefaultComponentAlignment(Alignment.TOP_LEFT);
        HorizontalLayout rightButtonGroup = new HorizontalLayout();
        rightButtonGroup.setSpacing(true);
        rightButtonGroup.addComponent((Component)filterTextField);
        rightButtonGroup.addComponent((Component)clearFilterButton);
        rightButtonGroup.addComponent((Component)refreshButton);
        rightButtonGroup.addComponent((Component)reloadButton);
        rightButtonGroup.setDefaultComponentAlignment(Alignment.TOP_RIGHT);
        HorizontalLayout upperLayout = new HorizontalLayout();
        upperLayout.setSpacing(true);
        upperLayout.addComponent((Component)leftButtonGroup);
        upperLayout.addComponent((Component)rightButtonGroup);
        upperLayout.setComponentAlignment((Component)leftButtonGroup, Alignment.TOP_LEFT);
        upperLayout.setComponentAlignment((Component)rightButtonGroup, Alignment.TOP_RIGHT);
        upperLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.addComponent((Component)upperLayout);
        Label sz = new Label("");
        sz.setWidth(null);
        sz.setHeight(5.0f, Sizeable.Unit.PIXELS);
        this.addComponent((Component)sz);
        this.addComponent((Component)this.m_table);
        this.setExpandRatio((Component)this.m_table, 1.0f);
        this.m_table.refresh();
    }

    public BusinessServiceManager getBusinessServiceManager() {
        return this.m_businessServiceManager;
    }
}

