/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.vaadin.data.Container;
import com.vaadin.data.util.BeanContainer;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Table;
import com.vaadin.ui.TreeTable;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEditWindow;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceRow;
import org.opennms.netmgt.vaadin.core.ConfirmationDialog;
import org.opennms.netmgt.vaadin.core.TransactionAwareUI;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceMainLayout
extends VerticalLayout {
    private static final long serialVersionUID = -6753816061488048389L;
    private final BusinessServiceManager m_businessServiceManager;
    private final TreeTable m_table = new TreeTable();
    private final BeanContainer<Long, BusinessServiceRow> m_beanContainer = new BeanContainer(BusinessServiceRow.class);
    private AtomicLong m_rowIdCounter = new AtomicLong();

    public BusinessServiceMainLayout(BusinessServiceManager businessServiceManager) {
        this.m_businessServiceManager = Objects.requireNonNull(businessServiceManager);
        this.setSizeFull();
        Button createButton = UIHelper.createButton((String)"New Business Service", null, (Resource)FontAwesome.PLUS_SQUARE, (Button.ClickListener & Serializable)event -> {
            BusinessService businessService = this.m_businessServiceManager.createBusinessService();
            BusinessServiceEditWindow window = new BusinessServiceEditWindow(businessService, this.m_businessServiceManager);
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.refreshTable());
            this.getUI().addWindow((Window)window);
        });
        createButton.setId("createButton");
        Button collapseButton = UIHelper.createButton((String)"Collapse All", null, (Resource)FontAwesome.FOLDER, (Button.ClickListener & Serializable)event -> this.m_table.getContainerDataSource().getItemIds().forEach(id -> this.m_table.setCollapsed(id, true)));
        collapseButton.setId("collapseButton");
        Button expandButton = UIHelper.createButton((String)"Expand All", null, (Resource)FontAwesome.FOLDER_OPEN, (Button.ClickListener & Serializable)event -> this.m_table.getContainerDataSource().getItemIds().forEach(id -> this.m_table.setCollapsed(id, false)));
        expandButton.setId("expandButton");
        Button refreshButton = UIHelper.createButton((String)"Refresh Table", null, (Resource)FontAwesome.REFRESH, (Button.ClickListener & Serializable)event -> this.refreshTable());
        refreshButton.setId("refreshButton");
        Button reloadButton = UIHelper.createButton((String)"Reload Daemon", (String)"Reloads the Business Service State Machine", (Resource)FontAwesome.RETWEET, (Button.ClickListener & Serializable)event -> this.m_businessServiceManager.triggerDaemonReload());
        reloadButton.setId("reloadButton");
        HorizontalLayout leftButtonGroup = new HorizontalLayout();
        leftButtonGroup.setSpacing(true);
        leftButtonGroup.addComponent((Component)createButton);
        leftButtonGroup.addComponent((Component)collapseButton);
        leftButtonGroup.addComponent((Component)expandButton);
        leftButtonGroup.setDefaultComponentAlignment(Alignment.TOP_LEFT);
        HorizontalLayout rightButtonGroup = new HorizontalLayout();
        rightButtonGroup.setSpacing(true);
        rightButtonGroup.addComponent((Component)refreshButton);
        rightButtonGroup.addComponent((Component)reloadButton);
        rightButtonGroup.setDefaultComponentAlignment(Alignment.TOP_RIGHT);
        HorizontalLayout upperLayout = new HorizontalLayout();
        upperLayout.setSpacing(true);
        upperLayout.addComponent((Component)leftButtonGroup);
        upperLayout.addComponent((Component)rightButtonGroup);
        upperLayout.setComponentAlignment((Component)leftButtonGroup, Alignment.TOP_LEFT);
        upperLayout.setComponentAlignment((Component)rightButtonGroup, Alignment.TOP_RIGHT);
        upperLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.addComponent((Component)upperLayout);
        Label sz = new Label("");
        sz.setWidth(null);
        sz.setHeight(5.0f, Sizeable.Unit.PIXELS);
        this.addComponent((Component)sz);
        this.m_table.setSizeFull();
        this.m_table.setContainerDataSource(this.m_beanContainer);
        this.m_table.setVisibleColumns(new Object[]{"name"});
        this.m_table.addGeneratedColumn((Object)"links", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 7113848887128656685L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                BusinessService businessService;
                HorizontalLayout layout = new HorizontalLayout();
                BusinessServiceStateMachine stateMachine = BusinessServiceMainLayout.this.m_businessServiceManager.getStateMachine();
                Status status = stateMachine.getOperationalStatus(businessService = ((BusinessServiceRow)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getBusinessService());
                if (status != null) {
                    ArrayList urlParms = Lists.newArrayList((Object[])new BasicNameValuePair[]{new BasicNameValuePair("focus-vertices", businessService.getId().toString()), new BasicNameValuePair("szl", "1"), new BasicNameValuePair("layout", "Hierarchy Layout"), new BasicNameValuePair("provider", "Business Services")});
                    String queryString = URLEncodedUtils.format((Iterable)urlParms, (Charset)Charset.forName("UTF-8"));
                    Link link = new Link("View in Topology UI", (Resource)new ExternalResource(String.format("/opennms/topology?%s", queryString)));
                    link.setIcon((Resource)FontAwesome.EXTERNAL_LINK_SQUARE);
                    link.setTargetName("_blank");
                    layout.addComponent((Component)link);
                    layout.setComponentAlignment((Component)link, Alignment.MIDDLE_CENTER);
                } else {
                    Label label = new Label("N/A");
                    label.setDescription("Try reloading the daemon and refreshing the table.");
                    label.setWidth(null);
                    layout.addComponent((Component)label);
                }
                return layout;
            }
        });
        this.m_table.addGeneratedColumn((Object)"edit / delete", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 7113848887128656685L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                HorizontalLayout layout = new HorizontalLayout();
                layout.setSpacing(true);
                Button editButton = new Button("Edit", (Resource)FontAwesome.PENCIL_SQUARE_O);
                editButton.setId("editButton-" + ((BusinessServiceRow)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getName());
                editButton.addClickListener((Button.ClickListener)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Button.ClickListener & Serializable)event -> {
                    Long businessServiceId = ((BusinessServiceRow)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getBusinessService().getId();
                    BusinessService businessService = BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById(businessServiceId);
                    BusinessServiceEditWindow window = new BusinessServiceEditWindow(businessService, BusinessServiceMainLayout.this.m_businessServiceManager);
                    window.addCloseListener((Window.CloseListener & Serializable)e -> BusinessServiceMainLayout.this.refreshTable());
                    BusinessServiceMainLayout.this.getUI().addWindow((Window)window);
                }));
                layout.addComponent((Component)editButton);
                Button deleteButton = new Button("Delete", (Resource)FontAwesome.TRASH_O);
                deleteButton.setId("deleteButton-" + ((BusinessServiceRow)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getName());
                deleteButton.addClickListener((Button.ClickListener & Serializable)event -> {
                    final Long businessServiceId = ((BusinessServiceRow)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getBusinessService().getId();
                    BusinessService businessService = BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById(businessServiceId);
                    if (businessService.getParentServices().isEmpty() && businessService.getChildEdges().isEmpty()) {
                        ((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).runInTransaction(() -> {
                            BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById(businessServiceId).delete();
                            BusinessServiceMainLayout.this.refreshTable();
                        });
                    } else {
                        new ConfirmationDialog().withOkAction((ConfirmationDialog.Action)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Object)new ConfirmationDialog.Action(){

                            public void execute(ConfirmationDialog window) {
                                BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById(businessServiceId).delete();
                                BusinessServiceMainLayout.this.refreshTable();
                            }
                        })).withOkLabel("Delete anyway").withCancelLabel("Cancel").withCaption("Warning").withDescription("This entry is referencing or is referenced by other Business Services! Do you really want to delete this entry?").open();
                    }
                });
                layout.addComponent((Component)deleteButton);
                return layout;
            }
        });
        this.m_table.setColumnExpandRatio((Object)"name", 5.0f);
        this.m_table.setColumnExpandRatio((Object)"links", 1.0f);
        this.m_table.setColumnExpandRatio((Object)"edit / delete", 1.0f);
        this.addComponent((Component)this.m_table);
        this.setExpandRatio((Component)this.m_table, 1.0f);
        this.refreshTable();
    }

    public BusinessServiceManager getBusinessServiceManager() {
        return this.m_businessServiceManager;
    }

    private void createRowForVertex(BusinessServiceGraph graph, GraphVertex graphVertex, BusinessServiceRow parentRow, com.google.common.collect.Table<Long, Optional<Long>, Boolean> collapseState) {
        BusinessService businessService = graphVertex.getBusinessService();
        if (businessService == null) {
            return;
        }
        long rowId = this.m_rowIdCounter.incrementAndGet();
        Long parentBusinessServiceId = parentRow != null ? parentRow.getBusinessService().getId() : null;
        BusinessServiceRow row = new BusinessServiceRow(rowId, businessService, parentBusinessServiceId);
        this.m_beanContainer.addBean((Object)row);
        if (parentRow != null) {
            this.m_table.setParent((Object)rowId, (Object)parentRow.getId());
        }
        Boolean wasCollapsed = (Boolean)collapseState.get((Object)businessService.getId(), Optional.ofNullable(parentBusinessServiceId));
        this.m_table.setCollapsed((Object)rowId, wasCollapsed != null ? wasCollapsed : true);
        graph.getOutEdges((Object)graphVertex).stream().map(e -> (GraphVertex)graph.getOpposite((Object)graphVertex, e)).filter(v -> v.getBusinessService() != null).sorted((v1, v2) -> v1.getBusinessService().getName().compareTo(v2.getBusinessService().getName())).forEach(v -> this.createRowForVertex(graph, (GraphVertex)v, row, collapseState));
    }

    private void refreshTable() {
        HashBasedTable collapseState = HashBasedTable.create();
        for (Long itemId : this.m_beanContainer.getItemIds()) {
            BusinessServiceRow row = (BusinessServiceRow)this.m_beanContainer.getItem((Object)itemId).getBean();
            collapseState.put((Object)row.getBusinessService().getId(), Optional.ofNullable(row.getParentBusinessServiceId()), (Object)this.m_table.isCollapsed((Object)itemId));
        }
        this.m_beanContainer.setBeanIdProperty((Object)"id");
        this.m_beanContainer.removeAllItems();
        this.m_rowIdCounter.set(0L);
        BusinessServiceGraph graph = this.m_businessServiceManager.getGraph(this.m_businessServiceManager.getAllBusinessServices());
        graph.getVerticesByLevel(0).stream().filter(v -> v.getBusinessService() != null).sorted((v1, v2) -> v1.getBusinessService().getName().compareTo(v2.getBusinessService().getName())).forEach(arg_0 -> this.lambda$refreshTable$20(graph, (com.google.common.collect.Table)collapseState, arg_0));
        for (Object itemId : this.m_table.getContainerDataSource().getItemIds()) {
            this.m_table.setChildrenAllowed(itemId, this.m_table.hasChildren(itemId));
        }
        this.fireItemSetChange();
    }

    private void fireItemSetChange() {
        this.m_table.containerItemSetChange(new Container.ItemSetChangeEvent(){
            private static final long serialVersionUID = 1L;

            public Container getContainer() {
                return BusinessServiceMainLayout.this.m_beanContainer;
            }
        });
    }

    private /* synthetic */ void lambda$refreshTable$20(BusinessServiceGraph graph, com.google.common.collect.Table collapseState, GraphVertex v) {
        this.createRowForVertex(graph, v, null, (com.google.common.collect.Table<Long, Optional<Long>, Boolean>)collapseState);
    }
}

