/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.vaadin.adminpage;

import com.vaadin.data.util.BeanContainer;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.vaadin.adminpage.BusinessServiceEditWindow;
import org.opennms.netmgt.vaadin.core.ConfirmationDialog;
import org.opennms.netmgt.vaadin.core.TransactionAwareUI;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceMainLayout
extends VerticalLayout {
    private static final long serialVersionUID = -6753816061488048389L;
    private final BusinessServiceManager m_businessServiceManager;
    private final Table m_table;
    private final BeanContainer<Long, BusinessService> m_beanContainer = new BeanContainer(BusinessService.class);

    public BusinessServiceMainLayout(BusinessServiceManager businessServiceManager) {
        this.m_businessServiceManager = Objects.requireNonNull(businessServiceManager);
        this.setSizeFull();
        HorizontalLayout upperLayout = new HorizontalLayout();
        Button reloadButton = UIHelper.createButton((String)"Reload Daemon", (String)"Reloads the Business Service State Machine", null, (Button.ClickListener & Serializable)event -> this.m_businessServiceManager.triggerDaemonReload());
        Button createButton = new Button("Create");
        createButton.setId("createButton");
        createButton.addClickListener((Button.ClickListener & Serializable)event -> {
            BusinessService businessService = this.m_businessServiceManager.createBusinessService();
            BusinessServiceEditWindow window = new BusinessServiceEditWindow(businessService, this.m_businessServiceManager);
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.refreshTable());
            this.getUI().addWindow((Window)window);
        });
        upperLayout.setSpacing(true);
        upperLayout.addComponent((Component)reloadButton);
        upperLayout.addComponent((Component)createButton);
        this.addComponent((Component)upperLayout);
        this.setComponentAlignment((Component)upperLayout, Alignment.TOP_RIGHT);
        this.m_table = new Table();
        this.m_table.setSizeFull();
        this.m_table.setContainerDataSource(this.m_beanContainer);
        this.m_table.setVisibleColumns(new Object[]{"id", "name"});
        this.m_table.addGeneratedColumn((Object)"edit", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 7113848887128656685L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                Button editButton = new Button("edit");
                editButton.addStyleName("small");
                editButton.setId("editButton-" + ((BusinessService)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getName());
                editButton.addClickListener((Button.ClickListener)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Button.ClickListener & Serializable)event -> {
                    BusinessService businessService = BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById((Long)itemId);
                    BusinessServiceEditWindow window = new BusinessServiceEditWindow(businessService, BusinessServiceMainLayout.this.m_businessServiceManager);
                    window.addCloseListener((Window.CloseListener & Serializable)e -> BusinessServiceMainLayout.this.refreshTable());
                    BusinessServiceMainLayout.this.getUI().addWindow((Window)window);
                }));
                return editButton;
            }
        });
        this.m_table.addGeneratedColumn((Object)"delete", new Table.ColumnGenerator(){
            private static final long serialVersionUID = 2425061320600155420L;

            public Object generateCell(Table source, final Object itemId, Object columnId) {
                Button deleteButton = new Button("delete");
                deleteButton.addStyleName("small");
                deleteButton.setId("deleteButton-" + ((BusinessService)BusinessServiceMainLayout.this.m_beanContainer.getItem(itemId).getBean()).getName());
                deleteButton.addClickListener((Button.ClickListener & Serializable)event -> {
                    BusinessService businessService = BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById((Long)itemId);
                    if (businessService.getParentServices().isEmpty() && businessService.getChildEdges().isEmpty()) {
                        ((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).runInTransaction(() -> {
                            BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById((Long)itemId).delete();
                            BusinessServiceMainLayout.this.refreshTable();
                        });
                    } else {
                        new ConfirmationDialog().withOkAction((ConfirmationDialog.Action)((TransactionAwareUI)UIHelper.getCurrent(TransactionAwareUI.class)).wrapInTransactionProxy((Object)new ConfirmationDialog.Action(){

                            public void execute(ConfirmationDialog window) {
                                BusinessServiceMainLayout.this.m_businessServiceManager.getBusinessServiceById((Long)itemId).delete();
                                BusinessServiceMainLayout.this.refreshTable();
                            }
                        })).withOkLabel("Delete anyway").withCancelLabel("Cancel").withCaption("Warning").withDescription("This entry is referencing or is referenced by other Business Services! Do you really want to delete this entry?").open();
                    }
                });
                return deleteButton;
            }
        });
        this.addComponent((Component)this.m_table);
        this.setExpandRatio((Component)this.m_table, 1.0f);
        this.refreshTable();
    }

    public BusinessServiceManager getBusinessServiceManager() {
        return this.m_businessServiceManager;
    }

    private void refreshTable() {
        this.m_beanContainer.setBeanIdProperty((Object)"id");
        this.m_beanContainer.removeAllItems();
        this.m_beanContainer.addAll((Collection)this.m_businessServiceManager.getAllBusinessServices());
        this.m_table.sort();
    }
}

