/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.test.hierarchies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.IPServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IdentityEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.HighestSeverityEntity;
import org.opennms.netmgt.bsm.test.BusinessServiceEntityBuilder;
import org.opennms.netmgt.dao.DatabasePopulator;

public class SimpleTestHierarchy {
    private final List<BusinessServiceEntity> businessServices = new ArrayList<BusinessServiceEntity>();

    public SimpleTestHierarchy(DatabasePopulator databasePopulator) {
        Objects.requireNonNull(databasePopulator);
        BusinessServiceEntity child1 = new BusinessServiceEntityBuilder().name("Child 1").addIpService(databasePopulator.getMonitoredServiceDao().get(databasePopulator.getNode1().getId(), InetAddressUtils.addr((String)"192.168.1.1"), "SNMP"), (AbstractMapFunctionEntity)new IdentityEntity()).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
        BusinessServiceEntity child2 = new BusinessServiceEntityBuilder().name("Child 2").addIpService(databasePopulator.getMonitoredServiceDao().get(databasePopulator.getNode2().getId(), InetAddressUtils.addr((String)"192.168.2.1"), "ICMP"), (AbstractMapFunctionEntity)new IdentityEntity()).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
        BusinessServiceEntity root = new BusinessServiceEntityBuilder().name("Parent").addChildren(child1, (AbstractMapFunctionEntity)new IdentityEntity()).addChildren(child2, (AbstractMapFunctionEntity)new IdentityEntity()).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
        this.businessServices.add(child1);
        this.businessServices.add(child2);
        this.businessServices.add(root);
    }

    public BusinessServiceEntity getRoot() {
        return this.businessServices.get(2);
    }

    public BusinessServiceEntity getChild1() {
        return this.businessServices.get(0);
    }

    public BusinessServiceEntity getChild2() {
        return this.businessServices.get(1);
    }

    public IPServiceEdgeEntity getServiceChild1() {
        return (IPServiceEdgeEntity)this.getChild1().getIpServiceEdges().iterator().next();
    }

    public IPServiceEdgeEntity getServiceChild2() {
        return (IPServiceEdgeEntity)this.getChild2().getIpServiceEdges().iterator().next();
    }

    public List<BusinessServiceEntity> getServices() {
        return Collections.unmodifiableList(this.businessServices);
    }
}

