/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.test;

import com.google.common.collect.Lists;
import java.util.List;
import org.opennms.netmgt.bsm.service.BusinessServiceStateChangeHandler;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;

public class LoggingStateChangeHandler
implements BusinessServiceStateChangeHandler {
    private final List<StateChange> m_stateChanges = Lists.newArrayList();

    public void handleBusinessServiceStateChanged(BusinessServiceGraph graph, BusinessService businessService, Status newStatus, Status prevStatus) {
        this.m_stateChanges.add(new StateChange(graph, businessService, newStatus, prevStatus));
    }

    public List<StateChange> getStateChanges() {
        return this.m_stateChanges;
    }

    public class StateChange {
        private final BusinessServiceGraph m_graph;
        private final BusinessService m_businessService;
        private final Status m_newStatus;
        private final Status m_prevStatus;

        public StateChange(BusinessServiceGraph graph, BusinessService businessService, Status newStatus, Status prevStatus) {
            this.m_graph = graph;
            this.m_businessService = businessService;
            this.m_newStatus = newStatus;
            this.m_prevStatus = prevStatus;
        }

        public BusinessService getBusinessService() {
            return this.m_businessService;
        }

        public BusinessServiceGraph getGraph() {
            return this.m_graph;
        }

        public Status getNewSeverity() {
            return this.m_newStatus;
        }

        public Status getPrevSeverity() {
            return this.m_prevStatus;
        }
    }
}

