/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.mock;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.mock.MockBusinessService;
import org.opennms.netmgt.bsm.mock.MockChildEdge;
import org.opennms.netmgt.bsm.mock.MockReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;

public class MockBusinessServiceHierarchy {
    private final HierarchyBuilder m_builder;

    public static HierarchyBuilder builder() {
        return new HierarchyBuilder();
    }

    private MockBusinessServiceHierarchy(HierarchyBuilder builder) {
        this.m_builder = builder;
    }

    public List<BusinessService> getBusinessServices() {
        return this.m_builder.m_businessServicesById.values().stream().map(b -> b).collect(Collectors.toList());
    }

    public BusinessService getBusinessServiceById(long id) {
        return (BusinessService)this.m_builder.m_businessServicesById.get(id);
    }

    public Edge getEdgeByReductionKey(String reductionKey) {
        return this.m_builder.m_businessServicesById.values().stream().map(MockBusinessService::getEdges).flatMap(Collection::stream).filter(e -> e.getReductionKeys().contains(reductionKey)).findFirst().orElse(null);
    }

    public static class HierarchyBuilder
    implements Builder {
        private final Map<Long, MockBusinessService> m_businessServicesById = Maps.newTreeMap();

        private MockBusinessService getOrCreateBusinessService(long businessServiceId) {
            MockBusinessService businessService = this.m_businessServicesById.get(businessServiceId);
            if (businessService == null) {
                businessService = new MockBusinessService(businessServiceId);
                this.m_businessServicesById.put(businessServiceId, businessService);
            }
            return businessService;
        }

        @Override
        public BusinessServiceBuilder withBusinessService(long businessServiceId) {
            return new BusinessServiceBuilder(this, this, this.getOrCreateBusinessService(businessServiceId));
        }

        @Override
        public HierarchyBuilder commit() {
            return this;
        }

        @Override
        public MockBusinessServiceHierarchy build() {
            return new MockBusinessServiceHierarchy(this);
        }

        public static class BusinessServiceBuilder
        implements Builder {
            private final HierarchyBuilder m_root;
            private final Builder m_parent;
            private final MockBusinessService m_businessService;
            private final Set<Edge> m_edges = Sets.newHashSet();

            private BusinessServiceBuilder(HierarchyBuilder root, Builder parent, MockBusinessService businessService) {
                this.m_root = root;
                this.m_parent = parent;
                this.m_businessService = businessService;
            }

            public BusinessServiceBuilder withName(String name) {
                this.m_businessService.setName(name);
                return this;
            }

            public BusinessServiceBuilder withReductionFunction(ReductionFunction reduce) {
                this.m_businessService.setReductionFunction(reduce);
                return this;
            }

            public BusinessServiceBuilder withReductionKey(long id, String reductionKey) {
                this.m_edges.add(new MockReductionKeyEdge(id, reductionKey, null));
                return this;
            }

            @Override
            public BusinessServiceBuilder withBusinessService(long businessServiceId) {
                MockBusinessService childService = this.m_root.getOrCreateBusinessService(businessServiceId);
                this.m_edges.add(new MockChildEdge(businessServiceId, childService));
                return new BusinessServiceBuilder(this.m_root, this, childService);
            }

            @Override
            public MockBusinessServiceHierarchy build() {
                throw new UnsupportedOperationException("Build can only be invoked on the root.");
            }

            @Override
            public Builder commit() {
                for (Edge edge : this.m_edges) {
                    this.m_businessService.addEdge(edge);
                }
                this.m_root.m_businessServicesById.put(this.m_businessService.getId(), this.m_businessService);
                return this.m_parent;
            }
        }
    }

    public static interface Builder {
        public HierarchyBuilder.BusinessServiceBuilder withBusinessService(long var1);

        public Builder commit();

        public MockBusinessServiceHierarchy build();
    }
}

