/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.test.hierarchies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IdentityEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IncreaseEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.HighestSeverityEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ThresholdEntity;
import org.opennms.netmgt.bsm.test.BusinessServiceEntityBuilder;

public class BambooTestHierarchy {
    public static final String DISK_USAGE_THRESHOLD_BAMBO_REDUCTION_KEY = "90% Disk Usage Threshold on bamboo";
    public static final String HTTP_8085_BAMBOO_REDUCTION_KEY = "HTTP-8085 on bamboo";
    public static final String BAMBOO_AGENT_DUKE_REDUCTION_KEY = "Bamboo-Agent on duke";
    public static final String BAMBOO_AGENT_CAROLINA_REDUCTION_KEY = "Bamboo-Agent on carolina";
    public static final String BAMBOO_AGENT_NCSTATE_REDUCTION_KEY = "Bamboo-Agent on ncstate";
    private final List<BusinessServiceEntity> businessServices = new ArrayList<BusinessServiceEntity>();

    public BambooTestHierarchy() {
        BusinessServiceEntity master = new BusinessServiceEntityBuilder().name("Master").addReductionKey(HTTP_8085_BAMBOO_REDUCTION_KEY, (AbstractMapFunctionEntity)new IncreaseEntity()).addReductionKey(DISK_USAGE_THRESHOLD_BAMBO_REDUCTION_KEY, (AbstractMapFunctionEntity)new IdentityEntity()).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
        BusinessServiceEntity agents = new BusinessServiceEntityBuilder().name("Agents").addReductionKey(BAMBOO_AGENT_DUKE_REDUCTION_KEY, (AbstractMapFunctionEntity)new IncreaseEntity(), 2).addReductionKey(BAMBOO_AGENT_CAROLINA_REDUCTION_KEY, (AbstractMapFunctionEntity)new IncreaseEntity(), 2).addReductionKey(BAMBOO_AGENT_NCSTATE_REDUCTION_KEY, (AbstractMapFunctionEntity)new IncreaseEntity(), 1).reduceFunction((AbstractReductionFunctionEntity)new ThresholdEntity(0.75f)).toEntity();
        BusinessServiceEntity root = new BusinessServiceEntityBuilder().name("Bamboo").addChildren(master, (AbstractMapFunctionEntity)new IdentityEntity()).addChildren(agents, (AbstractMapFunctionEntity)new IdentityEntity()).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
        this.businessServices.add(master);
        this.businessServices.add(agents);
        this.businessServices.add(root);
    }

    public List<BusinessServiceEntity> getServices() {
        return Collections.unmodifiableList(this.businessServices);
    }

    public BusinessServiceEntity getMasterService() {
        return this.businessServices.get(0);
    }

    public BusinessServiceEntity getAgentsService() {
        return this.businessServices.get(1);
    }

    public BusinessServiceEntity getBambooService() {
        return this.businessServices.get(2);
    }
}

