/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.test;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JacksonUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceChildEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;
import org.opennms.netmgt.bsm.persistence.api.IPServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.ReductionKeyHelper;
import org.opennms.netmgt.bsm.persistence.api.SingleReductionKeyEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.HighestSeverityEntity;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.test.BusinessServiceEntityBuilder;
import org.opennms.netmgt.bsm.test.MapFunctionMapper;
import org.opennms.netmgt.bsm.test.ReduceFunctionMapper;
import org.opennms.netmgt.bsm.test.SeverityMapper;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.api.ResourceLocationFactory;
import org.opennms.web.rest.v2.bsm.model.BusinessServiceRequestDTO;
import org.opennms.web.rest.v2.bsm.model.BusinessServiceResponseDTO;
import org.opennms.web.rest.v2.bsm.model.MapFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.ReduceFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ChildEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ReductionKeyEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionsManager;

public class BsmTestUtils {
    public static BusinessServiceRequestDTO toRequestDto(BusinessServiceEntity input) {
        Objects.requireNonNull(input);
        final BusinessServiceRequestDTO request = new BusinessServiceRequestDTO();
        request.setName(input.getName());
        request.setAttributes(new HashMap(input.getAttributes()));
        request.setReduceFunction(BsmTestUtils.transform(input.getReductionFunction()));
        input.getEdges().forEach(eachEdge -> {
            Void cfr_ignored_0 = (Void)eachEdge.accept((EdgeEntityVisitor)new EdgeEntityVisitor<Void>(){

                public Void visit(BusinessServiceChildEdgeEntity edgeEntity) {
                    request.addChildService(edgeEntity.getChild().getId().longValue(), BsmTestUtils.transform(edgeEntity.getMapFunction()), edgeEntity.getWeight());
                    return null;
                }

                public Void visit(SingleReductionKeyEdgeEntity edgeEntity) {
                    request.addReductionKey(edgeEntity.getReductionKey(), BsmTestUtils.transform(edgeEntity.getMapFunction()), edgeEntity.getWeight(), edgeEntity.getFriendlyName());
                    return null;
                }

                public Void visit(IPServiceEdgeEntity edgeEntity) {
                    request.addIpService(edgeEntity.getIpService().getId().intValue(), BsmTestUtils.transform(edgeEntity.getMapFunction()), edgeEntity.getWeight(), edgeEntity.getFriendlyName());
                    return null;
                }
            });
        });
        return request;
    }

    public static ReduceFunctionDTO transform(AbstractReductionFunctionEntity input) {
        Objects.requireNonNull(input);
        ReductionFunction reductionFunction = new ReduceFunctionMapper().toServiceFunction(input);
        return new FunctionsManager().getReduceFunctionDTO(reductionFunction);
    }

    private static MapFunctionDTO transform(AbstractMapFunctionEntity input) {
        Objects.requireNonNull(input);
        MapFunction mapFunction = new MapFunctionMapper().toServiceFunction(input);
        return new FunctionsManager().getMapFunctionDTO(mapFunction);
    }

    public static BusinessServiceResponseDTO toResponseDto(BusinessServiceEntity input) {
        Objects.requireNonNull(input);
        BusinessServiceResponseDTO response = new BusinessServiceResponseDTO();
        response.setId(input.getId().longValue());
        response.setName(input.getName());
        response.setReduceFunction(BsmTestUtils.transform(input.getReductionFunction()));
        response.setOperationalStatus(Status.INDETERMINATE);
        response.setAttributes(input.getAttributes());
        response.setLocation(ResourceLocationFactory.createBusinessServiceLocation((String)input.getId().toString()));
        response.setReductionKeys(input.getReductionKeyEdges().stream().map(it -> BsmTestUtils.toResponseDTO(it)).collect(Collectors.toList()));
        response.setIpServices(input.getIpServiceEdges().stream().map(it -> BsmTestUtils.toResponseDTO(it)).collect(Collectors.toList()));
        response.setChildren(input.getChildEdges().stream().map(it -> BsmTestUtils.toResponseDTO(it)).collect(Collectors.toList()));
        response.setParentServices((Set)Sets.newHashSet());
        return response;
    }

    public static ChildEdgeResponseDTO toResponseDTO(BusinessServiceChildEdgeEntity input) {
        ChildEdgeResponseDTO edge = new ChildEdgeResponseDTO();
        edge.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)input.getBusinessService().getId(), (long)input.getId()));
        edge.setReductionKeys(edge.getReductionKeys());
        edge.setMapFunction(BsmTestUtils.transform(input.getMapFunction()));
        edge.setId(input.getId().longValue());
        edge.setChildId(input.getChild().getId());
        edge.setWeight(input.getWeight());
        edge.setOperationalStatus(Status.INDETERMINATE);
        return edge;
    }

    public static IpServiceEdgeResponseDTO toResponseDTO(IPServiceEdgeEntity input) {
        IpServiceResponseDTO ipService = new IpServiceResponseDTO();
        ipService.setNodeLabel("dummy");
        ipService.setServiceName(input.getIpService().getServiceName());
        ipService.setId(input.getIpService().getId().intValue());
        ipService.setIpAddress(InetAddressUtils.toIpAddrString((InetAddress)input.getIpService().getIpAddress()));
        IpServiceEdgeResponseDTO edge = new IpServiceEdgeResponseDTO();
        edge.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)input.getBusinessService().getId(), (long)input.getId()));
        edge.setReductionKeys(ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)input.getIpService()));
        edge.setIpService(ipService);
        edge.setMapFunction(BsmTestUtils.transform(input.getMapFunction()));
        edge.setId(input.getId().longValue());
        edge.setWeight(input.getWeight());
        edge.setFriendlyName(input.getFriendlyName());
        edge.setOperationalStatus(Status.INDETERMINATE);
        return edge;
    }

    public static ReductionKeyEdgeResponseDTO toResponseDTO(SingleReductionKeyEdgeEntity input) {
        ReductionKeyEdgeResponseDTO edge = new ReductionKeyEdgeResponseDTO();
        edge.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)input.getBusinessService().getId(), (long)input.getId()));
        edge.setReductionKeys(input.getReductionKeys());
        edge.setReductionKey(input.getReductionKey());
        edge.setMapFunction(BsmTestUtils.transform(input.getMapFunction()));
        edge.setId(input.getId().longValue());
        edge.setWeight(input.getWeight());
        edge.setFriendlyName(input.getFriendlyName());
        edge.setOperationalStatus(Status.INDETERMINATE);
        return edge;
    }

    public static <T> String toJson(T input) {
        Objects.requireNonNull(input);
        try {
            return JacksonUtils.createDefaultObjectMapper().writeValueAsString(input);
        }
        catch (IOException io) {
            throw Throwables.propagate((Throwable)io);
        }
    }

    public static <T> String toXml(T input) {
        Objects.requireNonNull(input);
        return JaxbUtils.marshal(input);
    }

    private static OnmsAlarm createAlarm(OnmsMonitoredService monitoredService, OnmsSeverity severity) {
        return BsmTestUtils.createAlarm(Objects.requireNonNull(monitoredService.getNodeId()), Objects.requireNonNull(InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress())), Objects.requireNonNull(monitoredService.getServiceName()), Objects.requireNonNull(severity));
    }

    private static OnmsAlarm createAlarm(int nodeId, String ip, String service, OnmsSeverity severity) {
        OnmsAlarm alarm = BsmTestUtils.createAlarm("uei.opennms.org/nodes/nodeLostService", severity, String.format("%s::%s:%s:%s", "uei.opennms.org/nodes/nodeLostService", nodeId, ip, service));
        return alarm;
    }

    private static OnmsAlarm createAlarm(String uei, OnmsSeverity severity, String reductionKey) {
        OnmsAlarm customAlarm = new OnmsAlarm();
        customAlarm.setUei(Objects.requireNonNull(uei));
        customAlarm.setSeverity(Objects.requireNonNull(severity));
        customAlarm.setReductionKey(Objects.requireNonNull(reductionKey));
        return customAlarm;
    }

    public static AlarmWrapper createAlarmWrapper(String uei, OnmsSeverity severity, String reductionKey) {
        return BsmTestUtils.createAlarmWrapper(BsmTestUtils.createAlarm(uei, severity, reductionKey));
    }

    public static AlarmWrapper createAlarmWrapper(OnmsMonitoredService monitoredService, OnmsSeverity severity) {
        return BsmTestUtils.createAlarmWrapper(BsmTestUtils.createAlarm(monitoredService, severity));
    }

    private static AlarmWrapper createAlarmWrapper(final OnmsAlarm alarm) {
        return new AlarmWrapper(){

            public String getReductionKey() {
                return alarm.getReductionKey();
            }

            public Status getStatus() {
                return SeverityMapper.toStatus(alarm.getSeverity());
            }

            public Integer getId() {
                return alarm.getId();
            }
        };
    }

    public static OnmsMonitoredService createMonitoredService(final int serviceId, final int nodeId, final String ipAddress, final String serviceName) {
        return new OnmsMonitoredService(){
            private static final long serialVersionUID = 8510675581667310365L;

            public Integer getId() {
                return serviceId;
            }

            public Integer getNodeId() {
                return nodeId;
            }

            public InetAddress getIpAddress() {
                try {
                    return InetAddress.getByName(ipAddress);
                }
                catch (UnknownHostException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            public String getServiceName() {
                return serviceName;
            }

            public String toString() {
                return this.getServiceName();
            }
        };
    }

    public static BusinessServiceEntity createDummyBusinessService(String serviceName) {
        return new BusinessServiceEntityBuilder().name(serviceName).reduceFunction((AbstractReductionFunctionEntity)new HighestSeverityEntity()).toEntity();
    }
}

