/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.karaf.shell;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.functions.map.Identity;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverity;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;

@Command(scope="bsm", name="generate-hierarchies", description="Generates hierarchies.")
@Service
public class GenerateHierarchiesShellCommand
implements Action {
    private static final int DEFAULT_NUM_SERVICES = 1000;
    private static final int DEFAULT_DEPTH = 10;
    @Argument(index=0, name="num-services", description="The number of business services to generate.", required=false, multiValued=false)
    Integer numServices = null;
    @Argument(index=1, name="depth", description="The depth to use for each hierarchy.", required=false, multiValued=false)
    Integer depth = null;
    @Reference
    public BusinessServiceManager businessServiceManager;

    public Object execute() throws Exception {
        Map<String, BusinessService> businessServicesByName = this.businessServiceManager.getAllBusinessServices().stream().collect(Collectors.toMap(b -> b.getName(), b -> b));
        int showStatusEvery = 100;
        int numServicesToGenerate = this.numServices != null ? this.numServices : 1000;
        int depthPerHierarchy = this.depth != null ? this.depth : 10;
        int currentDepth = 0;
        BusinessService lastBusinessService = null;
        for (int i = 0; i < numServicesToGenerate; ++i) {
            String name;
            if (i % showStatusEvery == 0) {
                System.out.printf("Generating business services %d -> %d\n", i, Math.min(i + showStatusEvery, numServicesToGenerate));
            }
            if (businessServicesByName.containsKey(name = "B" + i)) {
                lastBusinessService = businessServicesByName.get(name);
                continue;
            }
            BusinessService businessService = this.businessServiceManager.createBusinessService();
            businessService.setName(name);
            businessService.setReduceFunction((ReductionFunction)new HighestSeverity());
            businessService.getAttributes().put("generated", "true");
            this.businessServiceManager.saveBusinessService(businessService);
            if (lastBusinessService != null && currentDepth < depthPerHierarchy) {
                this.businessServiceManager.addChildEdge(lastBusinessService, businessService, (MapFunction)new Identity(), 1);
                ++currentDepth;
            } else if (currentDepth >= depthPerHierarchy) {
                currentDepth = 0;
            }
            lastBusinessService = businessService;
        }
        return null;
    }

    public void setNumServices(Integer numServices) {
        this.numServices = numServices;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }
}

