/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.graph.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.EdgeVisitor;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.Identity;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverity;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphEdgeImpl;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphLevelIndexer;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphVertexImpl;

public class BusinessServiceGraphImpl
extends DirectedSparseMultigraph<GraphVertex, GraphEdge>
implements BusinessServiceGraph {
    private static final long serialVersionUID = -7575071727895407844L;
    private static final Identity MAP_IDENTITY = new Identity();
    private static final HighestSeverity REDUCE_HIGHEST_SEVERITY = new HighestSeverity();
    private final Map<Long, GraphVertex> m_verticesByBusinessServiceId = Maps.newHashMap();
    private final Map<Integer, GraphVertex> m_verticesByIpServiceId = Maps.newHashMap();
    private final Map<String, GraphVertex> m_verticesByReductionKey = Maps.newHashMap();
    private final Map<Long, GraphVertex> m_verticesByEdgeId = Maps.newHashMap();
    private final Map<Integer, Set<GraphVertex>> m_verticesByLevel = Maps.newHashMap();
    private final Map<Long, GraphEdge> m_edgesByEdgeId = Maps.newHashMap();

    public BusinessServiceGraphImpl(List<? extends BusinessService> businessServices) {
        Objects.requireNonNull(businessServices).stream().forEach(this::addBusinessServiceVertex);
        this.calculateAndIndexLevels();
    }

    private GraphVertex addBusinessServiceVertex(BusinessService businessService) {
        GraphVertex businessServiceVertex = this.m_verticesByBusinessServiceId.get(businessService.getId());
        if (businessServiceVertex != null) {
            return businessServiceVertex;
        }
        businessServiceVertex = new GraphVertexImpl(businessService.getReduceFunction(), businessService);
        this.addVertex(businessServiceVertex);
        this.m_verticesByBusinessServiceId.put(businessService.getId(), businessServiceVertex);
        for (Edge edge : businessService.getEdges()) {
            GraphEdgeImpl graphEdge = new GraphEdgeImpl(edge);
            final GraphVertex[] vertexForEdge = new GraphVertex[]{this.getExistingVertex(edge)};
            if (vertexForEdge[0] == null) {
                edge.accept((EdgeVisitor)new EdgeVisitor<Void>(){

                    public Void visit(ChildEdge edge) {
                        vertexForEdge[0] = BusinessServiceGraphImpl.this.addBusinessServiceVertex(edge.getChild());
                        return null;
                    }

                    public Void visit(IpServiceEdge edge) {
                        vertexForEdge[0] = new GraphVertexImpl((ReductionFunction)REDUCE_HIGHEST_SEVERITY, edge.getIpService());
                        BusinessServiceGraphImpl.this.addVertex(vertexForEdge[0]);
                        BusinessServiceGraphImpl.this.m_verticesByIpServiceId.put(vertexForEdge[0].getIpService().getId(), vertexForEdge[0]);
                        for (String reductionKey : edge.getReductionKeys()) {
                            GraphVertex reductionKeyVertex = (GraphVertex)BusinessServiceGraphImpl.this.m_verticesByReductionKey.get(reductionKey);
                            if (reductionKeyVertex == null) {
                                reductionKeyVertex = new GraphVertexImpl((ReductionFunction)REDUCE_HIGHEST_SEVERITY, reductionKey);
                                BusinessServiceGraphImpl.this.addVertex(reductionKeyVertex);
                                BusinessServiceGraphImpl.this.m_verticesByReductionKey.put(reductionKey, reductionKeyVertex);
                            }
                            GraphEdgeImpl intermediaryEdge = new GraphEdgeImpl((MapFunction)MAP_IDENTITY);
                            BusinessServiceGraphImpl.this.addEdge(intermediaryEdge, vertexForEdge[0], reductionKeyVertex);
                        }
                        return null;
                    }

                    public Void visit(ReductionKeyEdge edge) {
                        String reductionKey = edge.getReductionKey();
                        vertexForEdge[0] = new GraphVertexImpl((ReductionFunction)REDUCE_HIGHEST_SEVERITY, edge.getReductionKey());
                        BusinessServiceGraphImpl.this.addVertex(vertexForEdge[0]);
                        BusinessServiceGraphImpl.this.m_verticesByReductionKey.put(reductionKey, vertexForEdge[0]);
                        return null;
                    }
                });
            }
            this.addEdge(graphEdge, businessServiceVertex, vertexForEdge[0]);
            this.m_verticesByEdgeId.put(edge.getId(), vertexForEdge[0]);
            this.m_edgesByEdgeId.put(edge.getId(), graphEdge);
        }
        return businessServiceVertex;
    }

    private GraphVertex getExistingVertex(Edge edge) {
        return (GraphVertex)edge.accept((EdgeVisitor)new EdgeVisitor<GraphVertex>(){

            public GraphVertex visit(IpServiceEdge edge) {
                return (GraphVertex)BusinessServiceGraphImpl.this.m_verticesByIpServiceId.get(edge.getIpService().getId());
            }

            public GraphVertex visit(ReductionKeyEdge edge) {
                return (GraphVertex)BusinessServiceGraphImpl.this.m_verticesByReductionKey.get(edge.getReductionKey());
            }

            public GraphVertex visit(ChildEdge edge) {
                return (GraphVertex)BusinessServiceGraphImpl.this.m_verticesByBusinessServiceId.get(edge.getChild().getId());
            }
        });
    }

    private void calculateAndIndexLevels() {
        HashSet rootVertices = Sets.newHashSet();
        for (GraphVertex vertex : this.getVertices()) {
            if (this.getInEdges(vertex).size() != 0) continue;
            rootVertices.add(vertex);
        }
        GraphLevelIndexer levelIndexer = new GraphLevelIndexer();
        levelIndexer.indexLevel(this, rootVertices);
        for (Map.Entry entry : levelIndexer.getLevelMap().entrySet()) {
            int level = entry.getValue();
            GraphVertexImpl vertex = (GraphVertexImpl)entry.getKey();
            vertex.setLevel(Math.max(level, vertex.getLevel()));
        }
        for (GraphVertex vertex : this.getVertices()) {
            HashSet verticesAtLevel = this.m_verticesByLevel.get(vertex.getLevel());
            if (verticesAtLevel == null) {
                verticesAtLevel = Sets.newHashSet();
                this.m_verticesByLevel.put(vertex.getLevel(), verticesAtLevel);
            }
            verticesAtLevel.add(vertex);
        }
    }

    public GraphVertex getVertexByBusinessServiceId(Long id) {
        return this.m_verticesByBusinessServiceId.get(id);
    }

    public GraphVertex getVertexByIpServiceId(Integer id) {
        return this.m_verticesByIpServiceId.get(id);
    }

    public GraphVertex getVertexByReductionKey(String reductionKey) {
        return this.m_verticesByReductionKey.get(reductionKey);
    }

    public GraphVertex getVertexByEdgeId(Long id) {
        return this.m_verticesByEdgeId.get(id);
    }

    public GraphEdge getGraphEdgeByEdgeId(Long id) {
        return this.m_edgesByEdgeId.get(id);
    }

    public Set<String> getReductionKeys() {
        return this.m_verticesByReductionKey.keySet();
    }

    public Set<GraphVertex> getVerticesByLevel(int level) {
        Set<GraphVertex> verticesAtLevel = this.m_verticesByLevel.get(level);
        return verticesAtLevel != null ? verticesAtLevel : Collections.emptySet();
    }
}

