/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceChildEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.IPServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.SingleReductionKeyEdgeEntity;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.internal.ReduceFunctionMapper;
import org.opennms.netmgt.bsm.service.internal.edge.ChildEdgeImpl;
import org.opennms.netmgt.bsm.service.internal.edge.IpServiceEdgeImpl;
import org.opennms.netmgt.bsm.service.internal.edge.ReductionKeyEdgeImpl;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;

public class BusinessServiceImpl
implements BusinessService {
    private final BusinessServiceManager m_manager;
    private final BusinessServiceEntity m_entity;

    public BusinessServiceImpl(BusinessServiceManager manager, BusinessServiceEntity entity) {
        this.m_manager = manager;
        this.m_entity = entity;
    }

    public BusinessServiceEntity getEntity() {
        return this.m_entity;
    }

    public Long getId() {
        return this.m_entity.getId();
    }

    public String getName() {
        return this.m_entity.getName();
    }

    public void setName(String name) {
        this.m_entity.setName(name);
    }

    public Map<String, String> getAttributes() {
        return this.m_entity.getAttributes();
    }

    public void setAttributes(Map<String, String> attributes) {
        this.m_entity.setAttributes(attributes);
    }

    public Set<BusinessService> getChildServices() {
        return this.getChildEdges().stream().map(edge -> edge.getChild()).collect(Collectors.toSet());
    }

    public Set<BusinessService> getParentServices() {
        return this.m_manager.getParentServices(this.getId());
    }

    public void save() {
        this.m_manager.saveBusinessService((BusinessService)this);
    }

    public void delete() {
        this.m_manager.deleteBusinessService((BusinessService)this);
    }

    public Status getOperationalStatus() {
        return this.m_manager.getOperationalStatus((BusinessService)this);
    }

    public ReductionFunction getReduceFunction() {
        return new ReduceFunctionMapper().toServiceFunction(this.getEntity().getReductionFunction());
    }

    public void setReduceFunction(ReductionFunction reductionFunction) {
        this.m_manager.setReduceFunction((BusinessService)this, reductionFunction);
    }

    public Set<Edge> getEdges() {
        HashSet edges = Sets.newHashSet();
        edges.addAll(this.getIpServiceEdges());
        edges.addAll(this.getReductionKeyEdges());
        edges.addAll(this.getChildEdges());
        return edges;
    }

    public Set<IpServiceEdge> getIpServiceEdges() {
        return this.m_entity.getIpServiceEdges().stream().map(edge -> new IpServiceEdgeImpl(this.m_manager, (IPServiceEdgeEntity)edge)).collect(Collectors.toSet());
    }

    public void setIpServiceEdges(Set<IpServiceEdge> ipServiceEdges) {
        this.m_manager.setIpServiceEdges((BusinessService)this, ipServiceEdges);
    }

    public void addIpServiceEdge(IpService ipService, MapFunction mapFunction, int weight, String friendlyName) {
        this.m_manager.addIpServiceEdge((BusinessService)this, ipService, mapFunction, weight, friendlyName);
    }

    public Set<ReductionKeyEdge> getReductionKeyEdges() {
        return this.m_entity.getReductionKeyEdges().stream().map(edge -> new ReductionKeyEdgeImpl(this.m_manager, (SingleReductionKeyEdgeEntity)edge)).collect(Collectors.toSet());
    }

    public void setReductionKeyEdges(Set<ReductionKeyEdge> reductionKeyEdges) {
        this.m_manager.setReductionKeyEdges((BusinessService)this, reductionKeyEdges);
    }

    public void addReductionKeyEdge(String reductionKey, MapFunction mapFunction, int weight, String friendlyName) {
        this.m_manager.addReductionKeyEdge((BusinessService)this, reductionKey, mapFunction, weight, friendlyName);
    }

    public Set<ChildEdge> getChildEdges() {
        return this.m_entity.getChildEdges().stream().map(edge -> new ChildEdgeImpl(this.m_manager, (BusinessServiceChildEdgeEntity)edge)).collect(Collectors.toSet());
    }

    public void setChildEdges(Set<ChildEdge> childEdges) {
        this.m_manager.setChildEdges((BusinessService)this, childEdges);
    }

    public void addChildEdge(BusinessService child, MapFunction mapFunction, int weight) {
        this.m_manager.addChildEdge((BusinessService)this, child, mapFunction, weight);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessServiceImpl other = (BusinessServiceImpl)obj;
        return Objects.equals(this.getEntity(), other.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("attributes", this.getAttributes()).add("edges", this.getEdges()).add("operationalStatus", (Object)this.getOperationalStatus()).toString();
    }

    public void removeEdge(Edge edge) {
        this.m_manager.removeEdge((BusinessService)this, edge);
    }
}

