/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.bsm.service.AlarmProvider;
import org.opennms.netmgt.bsm.service.internal.AlarmWrapperImpl;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AlarmProviderImpl
implements AlarmProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmProviderImpl.class);
    private static final long DEFAULT_THRESHOLD = 1000L;
    private static final String THRESHOLD_KEY = "org.opennms.features.bsm.reductionKeyFullLoadThreshold";
    private final long threshold = AlarmProviderImpl.getThreshold();
    @Autowired
    private AlarmDao alarmDao;

    public Map<String, AlarmWrapper> lookup(Set<String> reductionKeys) {
        if (reductionKeys == null || reductionKeys.isEmpty()) {
            return new HashMap<String, AlarmWrapper>();
        }
        if ((long)reductionKeys.size() <= this.threshold) {
            List alarms = this.alarmDao.findMatching(new CriteriaBuilder(OnmsAlarm.class).in("reductionKey", reductionKeys).toCriteria());
            return alarms.stream().collect(Collectors.toMap(alarm -> alarm.getReductionKey(), alarm -> new AlarmWrapperImpl((OnmsAlarm)alarm)));
        }
        return this.alarmDao.findAll().stream().filter(a -> reductionKeys.contains(a.getReductionKey())).collect(Collectors.toMap(alarm -> alarm.getReductionKey(), alarm -> new AlarmWrapperImpl((OnmsAlarm)alarm)));
    }

    private static long getThreshold() {
        String thresholdProperty = System.getProperty(THRESHOLD_KEY, Long.toString(1000L));
        try {
            long threshold = Long.valueOf(thresholdProperty);
            if (threshold <= 0L) {
                LOG.warn("Defined threshold must be greater than 0, but was {}. Falling back to default: {}", (Object)threshold, (Object)1000L);
                return 1000L;
            }
            LOG.debug("Using threshold {}", (Object)threshold);
            return threshold;
        }
        catch (Exception ex) {
            LOG.warn("The defined threshold {} could not be interpreted as long value. Falling back to default: {}", (Object)thresholdProperty, (Object)1000L);
            return 1000L;
        }
    }
}

