/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.graph.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.internal.DefaultBusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class GraphAlgorithms {
    public static List<GraphVertex> calculateRootCause(BusinessServiceGraph graph, GraphVertex vertex) {
        if (vertex == null || vertex.getStatus().isLessThanOrEqual(Status.NORMAL)) {
            return Collections.emptyList();
        }
        List childVerticesWithImpact = GraphAlgorithms.calculateImpacting(graph, vertex).stream().map(e -> (GraphVertex)graph.getOpposite((Object)vertex, e)).sorted().collect(Collectors.toList());
        ArrayList causes = Lists.newArrayList(childVerticesWithImpact);
        for (GraphVertex childVertexWithImpact : childVerticesWithImpact) {
            causes.addAll(GraphAlgorithms.calculateRootCause(graph, childVertexWithImpact));
        }
        return causes;
    }

    public static List<GraphVertex> calculateImpact(BusinessServiceGraph graph, GraphVertex vertex) {
        if (vertex == null) {
            return Collections.emptyList();
        }
        List impactedParentVertices = graph.getInEdges((Object)vertex).stream().filter(e -> GraphAlgorithms.calculateImpacting(graph, (GraphVertex)graph.getOpposite((Object)vertex, e)).contains(e)).map(e -> (GraphVertex)graph.getOpposite((Object)vertex, e)).sorted().collect(Collectors.toList());
        ArrayList impacts = Lists.newArrayList(impactedParentVertices);
        for (GraphVertex impactedParentVertex : impactedParentVertices) {
            impacts.addAll(GraphAlgorithms.calculateImpact(graph, impactedParentVertex));
        }
        return impacts;
    }

    public static Set<GraphEdge> calculateImpacting(BusinessServiceGraph graph, GraphVertex parent) {
        List childEdges = graph.getOutEdges((Object)parent).stream().collect(Collectors.toList());
        Set powerSet = GraphAlgorithms.generatePowerSet(childEdges);
        List subsetsInAscendingSize = powerSet.stream().sorted((a, b) -> a.size() - b.size()).collect(Collectors.toList());
        ArrayList impactingSubsets = Lists.newArrayList();
        for (Set subSet : subsetsInAscendingSize) {
            if (impactingSubsets.size() > 0 && subSet.size() > ((Set)impactingSubsets.iterator().next()).size()) break;
            Map<GraphEdge, Status> edgesWithStatus = childEdges.stream().collect(Collectors.toMap(Function.identity(), e -> e.getStatus()));
            for (GraphEdge edge : subSet) {
                edgesWithStatus.put(edge, DefaultBusinessServiceStateMachine.MIN_SEVERITY);
            }
            List<Status> statuses = DefaultBusinessServiceStateMachine.weighStatuses(edgesWithStatus);
            Status reducedStatus = parent.getReductionFunction().reduce(statuses).orElse(DefaultBusinessServiceStateMachine.MIN_SEVERITY);
            if (!reducedStatus.isLessThan(parent.getStatus())) continue;
            impactingSubsets.add(subSet);
        }
        Sets.SetView union = Collections.emptySet();
        for (Set impactingSubset : impactingSubsets) {
            union = Sets.union(union, (Set)impactingSubset);
        }
        return union;
    }

    protected static <T> Set<Set<T>> generatePowerSet(Collection<T> elements) {
        Set powerSet = Sets.newConcurrentHashSet();
        powerSet.add(Sets.newHashSet());
        for (T element : elements) {
            for (Set existingSubset : powerSet) {
                HashSet newSubset = Sets.newHashSet((Iterable)existingSubset);
                newSubset.add(element);
                powerSet.add(newSubset);
            }
        }
        return powerSet;
    }
}

