/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteria;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;

public class BusinessServiceSearchCriteriaBuilder
implements BusinessServiceSearchCriteria {
    private List<String> m_nameFilters = new ArrayList<String>();
    private List<Pair<CompareOperator, Status>> m_severityFilters = new ArrayList<Pair<CompareOperator, Status>>();
    private List<Pair<String, String>> m_attributeFilters = new ArrayList<Pair<String, String>>();
    private Order m_order = Order.Name;
    private int m_limit = 0;
    private int m_offset = 0;
    private Sequence m_sequence = Sequence.Ascending;

    @Override
    public List<BusinessService> apply(final BusinessServiceManager businessServiceManager, List<BusinessService> businessServiceDTOs) {
        Stream<Object> s = businessServiceDTOs.stream();
        for (String string : this.m_nameFilters) {
            s = s.filter(p -> p.getName().matches(nameRegexp));
        }
        for (Pair pair : this.m_attributeFilters) {
            s = s.filter(p -> p.getAttributes().containsKey(pair.getA()) && p.getAttributes().get(pair.getA()).matches((String)pair.getB()));
        }
        if (!this.m_severityFilters.isEmpty()) {
            s = s.filter(bs -> {
                boolean accepted = false;
                for (Pair<CompareOperator, Status> pair : this.m_severityFilters) {
                    accepted |= pair.getA().check(businessServiceManager.getOperationalStatus((BusinessService)bs).compareTo((Enum)pair.getB()));
                }
                return accepted;
            });
        }
        Comparator<BusinessService> comparator = new Comparator<BusinessService>(){
            private final BusinessServiceGraph graph;
            {
                this.graph = businessServiceManager.getGraph();
            }

            @Override
            public int compare(BusinessService p1, BusinessService p2) {
                switch (BusinessServiceSearchCriteriaBuilder.this.m_order) {
                    case Name: {
                        return p1.getName().compareTo(p2.getName());
                    }
                    case Severity: {
                        return businessServiceManager.getOperationalStatus(p1).compareTo(businessServiceManager.getOperationalStatus(p2));
                    }
                    case Level: {
                        return Integer.compare(this.graph.getVertexByBusinessServiceId(p1.getId()).getLevel(), this.graph.getVertexByBusinessServiceId(p2.getId()).getLevel());
                    }
                }
                throw new IllegalArgumentException("Order not set");
            }
        };
        if (this.m_sequence.equals((Object)Sequence.Descending)) {
            comparator = comparator.reversed();
        }
        s = s.sorted((Comparator<Object>)comparator);
        if (this.m_offset > 0) {
            s = s.skip(this.m_offset);
        }
        if (this.m_limit > 0) {
            s = s.limit(this.m_limit);
        }
        return s.collect(Collectors.toList());
    }

    public BusinessServiceSearchCriteriaBuilder attribute(String key, String valueRegexp) {
        this.m_attributeFilters.add(Pair.of(key, valueRegexp));
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder name(String nameRegexp) {
        this.m_nameFilters.add(nameRegexp);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder order(Order order) {
        this.m_order = order;
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder filterSeverity(CompareOperator compareOperator, Status severity) {
        this.m_severityFilters.add(Pair.of(compareOperator, severity));
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder greaterOrEqualSeverity(Status severity) {
        this.filterSeverity(CompareOperator.GreaterOrEqual, severity);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder equalSeverity(Status severity) {
        this.filterSeverity(CompareOperator.Equal, severity);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder lowerOrEqualSeverity(Status severity) {
        this.filterSeverity(CompareOperator.LowerOrEqual, severity);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder lowerSeverity(Status severity) {
        this.filterSeverity(CompareOperator.Lower, severity);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder greaterSeverity(Status severity) {
        this.filterSeverity(CompareOperator.Greater, severity);
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder inSeverity(List<Status> severities) {
        for (Status eachStatus : severities) {
            this.filterSeverity(CompareOperator.Equal, eachStatus);
        }
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder limit(int limit) {
        this.m_limit = limit;
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder offset(int offset) {
        this.m_offset = offset;
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder order(Sequence sequence) {
        this.m_sequence = sequence;
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder order(String column, boolean asc) {
        this.order(Order.of(column));
        this.order(Sequence.of(asc));
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder asc() {
        this.m_sequence = Sequence.Ascending;
        return this;
    }

    public BusinessServiceSearchCriteriaBuilder desc() {
        this.m_sequence = Sequence.Descending;
        return this;
    }

    public void prepareForCounting() {
        this.m_order = Order.Name;
        this.m_limit = 0;
        this.m_offset = 0;
    }

    public Order getOrder() {
        return this.m_order;
    }

    public Sequence getSequence() {
        return this.m_sequence;
    }

    private static class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "Pair (" + this.a + "," + this.b + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            if (this.a != null ? !this.a.equals(pair.a) : pair.a != null) {
                return false;
            }
            return this.b != null ? this.b.equals(pair.b) : pair.b == null;
        }

        public int hashCode() {
            int result = this.a != null ? this.a.hashCode() : 0;
            result = 31 * result + (this.b != null ? this.b.hashCode() : 0);
            return result;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public static <A, B> Pair<A, B> of(A a, B b) {
            return new Pair<A, B>(a, b);
        }
    }

    public static enum Sequence {
        Ascending,
        Descending;


        public static Sequence of(boolean asc) {
            if (asc) {
                return Ascending;
            }
            return Descending;
        }
    }

    public static enum Order {
        Name,
        Severity,
        Level;


        public static Order of(String column) {
            for (Order order : Order.values()) {
                if (!order.name().equalsIgnoreCase(column)) continue;
                return order;
            }
            throw new IllegalArgumentException("No column found with name '" + column + "'. Valid values are: " + Arrays.toString((Object[])Order.values()));
        }
    }

    public static enum CompareOperator {
        Equal{

            @Override
            public boolean check(int a) {
                return a == 0;
            }
        }
        ,
        LowerOrEqual{

            @Override
            public boolean check(int a) {
                return a <= 0;
            }
        }
        ,
        GreaterOrEqual{

            @Override
            public boolean check(int a) {
                return a >= 0;
            }
        }
        ,
        Greater{

            @Override
            public boolean check(int a) {
                return a > 0;
            }
        }
        ,
        Lower{

            @Override
            public boolean check(int a) {
                return a < 0;
            }
        };


        public abstract boolean check(int var1);
    }
}

