/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.StatusWithIndex;
import org.opennms.netmgt.bsm.service.model.StatusWithIndices;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.StatusUtils;

@Function(name="Threshold", description="Uses the highest severity found more often than the given threshold.")
public class Threshold
implements ReductionFunction {
    private static final Comparator<Status> HIGHEST_SEVERITY_FIRST = new Comparator<Status>(){

        @Override
        public int compare(Status s1, Status s2) {
            return s2.compareTo(s1);
        }
    };
    @Parameter(key="threshold", description="The Threshold to use")
    private float m_threshold;

    public void setThreshold(float threshold) {
        Preconditions.checkArgument((threshold > 0.0f ? 1 : 0) != 0, (Object)"threshold must be strictly positive");
        Preconditions.checkArgument((threshold <= 1.0f ? 1 : 0) != 0, (Object)"threshold must be less or equal to 1");
        this.m_threshold = threshold;
    }

    public float getThreshold() {
        return this.m_threshold;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("threshold", this.m_threshold).toString();
    }

    @Override
    public Optional<StatusWithIndices> reduce(List<StatusWithIndex> statuses) {
        Map<Status, Integer> hitsByStatus = this.getHitsByStatusWithIndex(statuses);
        for (Map.Entry<Status, Integer> statusWithHits : hitsByStatus.entrySet()) {
            if (!((double)statusWithHits.getValue().intValue() / (double)statuses.size() >= (double)this.m_threshold)) continue;
            return Optional.of(new StatusWithIndices(statusWithHits.getKey(), StatusUtils.getIndicesWithStatusGe(statuses, statusWithHits.getKey())));
        }
        return Optional.empty();
    }

    @Override
    public <T> T accept(ReduceFunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Map<Status, Integer> getHitsByStatusWithIndex(List<StatusWithIndex> statuses) {
        return this.getHitsByStatus(statuses.stream().map(si -> si.getStatus()).collect(Collectors.toList()));
    }

    public Map<Status, Integer> getHitsByStatus(List<Status> statuses) {
        TreeMap<Status, Integer> hitsByStatus = new TreeMap<Status, Integer>(HIGHEST_SEVERITY_FIRST);
        for (Status s : statuses) {
            for (Status ss : Status.values()) {
                if (ss.isGreaterThan(s)) continue;
                Integer count = (Integer)hitsByStatus.get(ss);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                hitsByStatus.put(ss, count);
            }
        }
        return hitsByStatus;
    }
}

