/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.StatusWithIndex;
import org.opennms.netmgt.bsm.service.model.StatusWithIndices;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.StatusUtils;

@Function(name="HighestSeverityAbove", description="Uses the highest severity greater than the given threshold severity")
public class HighestSeverityAbove
implements ReductionFunction {
    @Parameter(key="threshold", description="The status value to use as threshold")
    private Status threshold;

    @Override
    public Optional<StatusWithIndices> reduce(List<StatusWithIndex> statuses) {
        return HighestSeverityAbove.reduceWithHighestSeverityAbove(statuses, this.threshold);
    }

    protected static Optional<StatusWithIndices> reduceWithHighestSeverityAbove(List<StatusWithIndex> statuses, Status threshold) {
        Status highestSeverity = statuses.stream().map(si -> si.getStatus()).filter(s -> s.isGreaterThan(threshold)).reduce((a, b) -> a.isGreaterThan((Status)b) ? a : b).orElse(null);
        if (highestSeverity == null) {
            return Optional.empty();
        }
        return Optional.of(new StatusWithIndices(highestSeverity, StatusUtils.getIndicesWithStatusGe(statuses, highestSeverity)));
    }

    public void setThreshold(Status threshold) {
        this.threshold = Objects.requireNonNull(threshold);
    }

    public Status getThreshold() {
        return this.threshold;
    }

    @Override
    public <T> T accept(ReduceFunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

