/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;

@Function(name="ExponentialPropagation", description="Propagate severities using a given base number")
public class ExponentialPropagation
implements ReductionFunction {
    @Parameter(key="base", defaultValue="2.0", description="The base used to calculate the required elements for propagation")
    private double base;

    @Override
    public Optional<Status> reduce(List<Status> statuses) {
        if (statuses.isEmpty()) {
            return Optional.empty();
        }
        if (Iterables.all(statuses, s -> s == Status.INDETERMINATE)) {
            return Optional.of(Status.INDETERMINATE);
        }
        double sum = statuses.stream().filter(status -> status.ordinal() >= Status.WARNING.ordinal()).mapToDouble(status -> Math.pow(this.base, status.ordinal() - Status.WARNING.ordinal())).sum();
        int res = (int)Math.floor(Math.log(sum) / Math.log(this.base)) + Status.WARNING.ordinal();
        return Optional.of(Status.get(Math.max(Math.min(res, Status.CRITICAL.ordinal()), Status.NORMAL.ordinal())));
    }

    public void setBase(double base) {
        Preconditions.checkArgument((base > 1.0 ? 1 : 0) != 0);
        this.base = base;
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public <T> T accept(ReduceFunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

