/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model;

import java.io.Serializable;

public enum Status implements Serializable
{
    INDETERMINATE("Indeterminate"),
    NORMAL("Normal"),
    WARNING("Warning"),
    MINOR("Minor"),
    MAJOR("Major"),
    CRITICAL("Critical");

    private String m_label;

    private Status(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public boolean isLessThan(Status other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqual(Status other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(Status other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(Status other) {
        return this.compareTo(other) >= 0;
    }

    public int getId() {
        return this.ordinal();
    }

    public static Status get(int ordinal) {
        for (Status eachStatus : Status.values()) {
            if (eachStatus.ordinal() != ordinal) continue;
            return eachStatus;
        }
        throw new IllegalArgumentException("Cannot create Status from unknown ordinal " + ordinal);
    }

    public String toString() {
        return this.getLabel();
    }
}

