/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service;

import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteria;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.NodeManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;

public interface BusinessServiceManager
extends NodeManager {
    public List<BusinessService> getAllBusinessServices();

    public List<BusinessService> search(BusinessServiceSearchCriteria var1);

    public List<BusinessService> findMatching(Criteria var1);

    public int countMatching(Criteria var1);

    public BusinessService createBusinessService();

    public Edge getEdgeById(Long var1);

    public boolean deleteEdge(BusinessService var1, Edge var2);

    public void saveBusinessService(BusinessService var1);

    public void deleteBusinessService(BusinessService var1);

    public BusinessService getBusinessServiceById(Long var1);

    public Set<BusinessService> getFeasibleChildServices(BusinessService var1);

    public Status getOperationalStatus(BusinessService var1);

    public Status getOperationalStatus(IpService var1);

    public Status getOperationalStatus(String var1);

    public Status getOperationalStatus(Edge var1);

    public List<IpService> getAllIpServices();

    public IpService getIpServiceById(Integer var1);

    public void triggerDaemonReload();

    public Set<BusinessService> getParentServices(Long var1);

    public void setChildEdges(BusinessService var1, Set<ChildEdge> var2);

    public boolean addChildEdge(BusinessService var1, BusinessService var2, MapFunction var3, int var4);

    public void setIpServiceEdges(BusinessService var1, Set<IpServiceEdge> var2);

    public boolean addIpServiceEdge(BusinessService var1, IpService var2, MapFunction var3, int var4);

    public boolean addIpServiceEdge(BusinessService var1, IpService var2, MapFunction var3, int var4, String var5);

    public boolean addReductionKeyEdge(BusinessService var1, String var2, MapFunction var3, int var4);

    public boolean addReductionKeyEdge(BusinessService var1, String var2, MapFunction var3, int var4, String var5);

    public void setReductionKeyEdges(BusinessService var1, Set<ReductionKeyEdge> var2);

    public void removeEdge(BusinessService var1, Edge var2);

    public BusinessServiceGraph getGraph();

    public BusinessServiceStateMachine getStateMachine();

    public void setMapFunction(Edge var1, MapFunction var2);

    public void setReduceFunction(BusinessService var1, ReductionFunction var2);
}

