/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.bsm;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.EdgeVisitor;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.web.rest.api.ResourceLocationFactory;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.bsm.model.BusinessServiceListDTO;
import org.opennms.web.rest.v2.bsm.model.BusinessServiceRequestDTO;
import org.opennms.web.rest.v2.bsm.model.BusinessServiceResponseDTO;
import org.opennms.web.rest.v2.bsm.model.MapFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.ReduceFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.edge.AbstractEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ChildEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ChildEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.EdgeRequestDTOVisitor;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceResponseDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ReductionKeyEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ReductionKeyEdgeResponseDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionMetaDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionMetaListDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionType;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="business-services")
@Transactional
@Produces(value={"application/json", "application/xml", "application/atom+xml"})
@Consumes(value={"application/json", "application/xml", "application/atom+xml"})
public class BusinessServiceRestService {
    @Autowired
    private BusinessServiceManager businessServiceManager;

    protected BusinessServiceManager getManager() {
        return this.businessServiceManager;
    }

    @GET
    public Response list() {
        List services = this.getManager().getAllBusinessServices();
        if (services == null || services.isEmpty()) {
            return Response.noContent().build();
        }
        BusinessServiceListDTO serviceList = new BusinessServiceListDTO((Collection)services);
        return Response.ok((Object)serviceList).build();
    }

    @GET
    @Path(value="{id}")
    public Response getById(@PathParam(value="id") Long id) {
        BusinessService service = this.getManager().getBusinessServiceById(id);
        final BusinessServiceResponseDTO response = new BusinessServiceResponseDTO();
        response.setId(service.getId().longValue());
        response.setName(service.getName());
        response.setAttributes(service.getAttributes());
        response.setLocation(ResourceLocationFactory.createBusinessServiceLocation((String)service.getId().toString()));
        response.setParentServices(service.getParentServices().stream().map(BusinessService::getId).collect(Collectors.toSet()));
        response.setOperationalStatus(service.getOperationalStatus());
        response.setReduceFunction(this.transform(service.getReduceFunction()));
        service.getEdges().forEach(eachEdge -> {
            Void cfr_ignored_0 = (Void)eachEdge.accept((EdgeVisitor)new EdgeVisitor<Void>(){

                public Void visit(IpServiceEdge edge) {
                    response.getIpServices().add(BusinessServiceRestService.this.transform(edge));
                    return null;
                }

                public Void visit(ReductionKeyEdge edge) {
                    response.getReductionKeys().add(BusinessServiceRestService.this.transform(edge));
                    return null;
                }

                public Void visit(ChildEdge edge) {
                    response.getChildren().add(BusinessServiceRestService.this.transform(edge));
                    return null;
                }
            });
        });
        return Response.ok((Object)response).build();
    }

    @POST
    public Response create(@Context UriInfo uriInfo, BusinessServiceRequestDTO request) {
        final BusinessService service = this.getManager().createBusinessService();
        service.setName(request.getName());
        service.setAttributes(request.getAttributes());
        service.setReduceFunction(this.transform(request.getReduceFunction()));
        request.getEdges().forEach(eachEdge -> eachEdge.accept(new EdgeRequestDTOVisitor(){

            public void visit(IpServiceEdgeRequestDTO ipEdge) {
                service.addIpServiceEdge(BusinessServiceRestService.this.getManager().getIpServiceById(ipEdge.getIpServiceId()), BusinessServiceRestService.this.transform(ipEdge.getMapFunction()), ipEdge.getWeight(), ipEdge.getFriendlyName());
            }

            public void visit(ChildEdgeRequestDTO childEdge) {
                service.addChildEdge(BusinessServiceRestService.this.getManager().getBusinessServiceById(childEdge.getChildId()), BusinessServiceRestService.this.transform(childEdge.getMapFunction()), childEdge.getWeight());
            }

            public void visit(ReductionKeyEdgeRequestDTO rkEdge) {
                service.addReductionKeyEdge(rkEdge.getReductionKey(), BusinessServiceRestService.this.transform(rkEdge.getMapFunction()), rkEdge.getWeight(), rkEdge.getFriendlyName());
            }
        }));
        this.getManager().saveBusinessService(service);
        return Response.created((URI)RedirectHelper.getRedirectUri((UriInfo)uriInfo, (Object[])new Object[]{service.getId()})).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") Long id) {
        BusinessService service = this.getManager().getBusinessServiceById(id);
        this.getManager().deleteBusinessService(service);
        return Response.ok().build();
    }

    @PUT
    @Path(value="{id}")
    public Response update(@PathParam(value="id") Long id, BusinessServiceRequestDTO request) {
        final BusinessService service = this.getManager().getBusinessServiceById(id);
        service.setName(request.getName());
        service.setAttributes(request.getAttributes());
        service.setReduceFunction(this.transform(request.getReduceFunction()));
        service.setReductionKeyEdges((Set)Sets.newHashSet());
        service.setIpServiceEdges((Set)Sets.newHashSet());
        service.setChildEdges((Set)Sets.newHashSet());
        request.getEdges().forEach(eachEdge -> eachEdge.accept(new EdgeRequestDTOVisitor(){

            public void visit(IpServiceEdgeRequestDTO ipEdge) {
                BusinessServiceRestService.this.getManager().addIpServiceEdge(service, BusinessServiceRestService.this.getManager().getIpServiceById(ipEdge.getIpServiceId()), BusinessServiceRestService.this.transform(ipEdge.getMapFunction()), ipEdge.getWeight(), ipEdge.getFriendlyName());
            }

            public void visit(ChildEdgeRequestDTO childEdge) {
                BusinessServiceRestService.this.getManager().addChildEdge(service, BusinessServiceRestService.this.getManager().getBusinessServiceById(childEdge.getChildId()), BusinessServiceRestService.this.transform(childEdge.getMapFunction()), childEdge.getWeight());
            }

            public void visit(ReductionKeyEdgeRequestDTO rkEdge) {
                BusinessServiceRestService.this.getManager().addReductionKeyEdge(service, rkEdge.getReductionKey(), BusinessServiceRestService.this.transform(rkEdge.getMapFunction()), rkEdge.getWeight(), rkEdge.getFriendlyName());
            }
        }));
        this.getManager().saveBusinessService(service);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/edges/{edgeId}")
    public Response getEdgeById(@PathParam(value="edgeId") Long edgeId) {
        Edge edge = this.getManager().getEdgeById(edgeId);
        AbstractEdgeResponseDTO edgeDTO = this.transform(edge);
        return Response.ok().entity((Object)edgeDTO).build();
    }

    @POST
    @Path(value="{id}/ip-service-edge")
    public Response addIpServiceEdge(@PathParam(value="id") Long serviceId, IpServiceEdgeRequestDTO edgeRequest) {
        BusinessService businessService = this.getManager().getBusinessServiceById(serviceId);
        IpService ipService = this.getManager().getIpServiceById(edgeRequest.getIpServiceId());
        boolean changed = this.getManager().addIpServiceEdge(businessService, ipService, this.transform(edgeRequest.getMapFunction()), edgeRequest.getWeight(), edgeRequest.getFriendlyName());
        if (!changed) {
            return Response.notModified().build();
        }
        businessService.save();
        return Response.ok().build();
    }

    @POST
    @Path(value="{id}/reduction-key-edge")
    public Response addReductionKeyEdge(@PathParam(value="id") Long serviceId, ReductionKeyEdgeRequestDTO edgeRequest) {
        BusinessService businessService = this.getManager().getBusinessServiceById(serviceId);
        boolean changed = this.getManager().addReductionKeyEdge(businessService, edgeRequest.getReductionKey(), this.transform(edgeRequest.getMapFunction()), edgeRequest.getWeight(), edgeRequest.getFriendlyName());
        if (!changed) {
            return Response.notModified().build();
        }
        businessService.save();
        return Response.ok().build();
    }

    @POST
    @Path(value="{id}/child-edge")
    public Response addChildServiceEdge(@PathParam(value="id") Long serviceId, ChildEdgeRequestDTO edgeRequest) {
        BusinessService parentService = this.getManager().getBusinessServiceById(serviceId);
        BusinessService childService = this.getManager().getBusinessServiceById(edgeRequest.getChildId());
        boolean changed = this.getManager().addChildEdge(parentService, childService, this.transform(edgeRequest.getMapFunction()), edgeRequest.getWeight());
        if (!changed) {
            return Response.notModified().build();
        }
        parentService.save();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{id}/edges/{edgeId}")
    public Response removeEdge(@PathParam(value="id") Long serviceId, @PathParam(value="edgeId") Long edgeId) {
        BusinessService service = this.getManager().getBusinessServiceById(serviceId);
        Edge edge = this.getManager().getEdgeById(edgeId);
        boolean changed = this.getManager().deleteEdge(service, edge);
        if (!changed) {
            return Response.notModified().build();
        }
        service.save();
        return Response.ok().build();
    }

    @POST
    @Path(value="daemon/reload")
    public Response reload() {
        this.getManager().triggerDaemonReload();
        return Response.ok().build();
    }

    @GET
    @Path(value="functions/map")
    public Response listMapFunctions() {
        return this.createFunctionMetaListDTO(new FunctionsManager().getMapFunctions(), FunctionType.MapFunction);
    }

    @GET
    @Path(value="functions/map/{name}")
    public Response getMapFunctionMetaData(@PathParam(value="name") String name) {
        FunctionMetaDTO metaData = new FunctionsManager().getMapFunctionMetaData(name);
        if (metaData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No map function with name '" + name + "' found.")).build();
        }
        return Response.ok().entity((Object)metaData).build();
    }

    @GET
    @Path(value="functions/reduce")
    public Response listReduceFunctions() {
        return this.createFunctionMetaListDTO(new FunctionsManager().getReduceFunctions(), FunctionType.ReduceFunction);
    }

    @GET
    @Path(value="functions/reduce/{name}")
    public Response getReduceFunctionMetaData(@PathParam(value="name") String name) {
        FunctionMetaDTO metaData = new FunctionsManager().getReduceFunctionMetaData(name);
        if (metaData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No reduce function with name '" + name + "' found.")).build();
        }
        return Response.ok().entity((Object)metaData).build();
    }

    private Response createFunctionMetaListDTO(List<Class<?>> functions, FunctionType functionType) {
        if (functions == null || functions.isEmpty()) {
            return Response.noContent().build();
        }
        List functionList = functions.stream().map(functionMetaData -> new FunctionMetaDTO(functionMetaData, functionType)).collect(Collectors.toList());
        return Response.ok().entity((Object)new FunctionMetaListDTO(functionList)).build();
    }

    private IpServiceResponseDTO transform(IpService input) {
        IpServiceResponseDTO response = new IpServiceResponseDTO();
        response.setId(input.getId());
        response.setNodeLabel(input.getNodeLabel());
        response.setServiceName(input.getServiceName());
        response.setIpAddress(input.getIpAddress());
        response.setLocation(ResourceLocationFactory.createIpServiceLocation((String)String.valueOf(input.getId())));
        return response;
    }

    private AbstractEdgeResponseDTO transform(Edge edge) {
        Objects.requireNonNull(edge);
        return (AbstractEdgeResponseDTO)edge.accept((EdgeVisitor)new EdgeVisitor<AbstractEdgeResponseDTO>(){

            public AbstractEdgeResponseDTO visit(IpServiceEdge edge) {
                return BusinessServiceRestService.this.transform(edge);
            }

            public AbstractEdgeResponseDTO visit(ReductionKeyEdge edge) {
                return BusinessServiceRestService.this.transform(edge);
            }

            public AbstractEdgeResponseDTO visit(ChildEdge edge) {
                return BusinessServiceRestService.this.transform(edge);
            }
        });
    }

    private IpServiceEdgeResponseDTO transform(IpServiceEdge edge) {
        IpServiceEdgeResponseDTO response = new IpServiceEdgeResponseDTO();
        response.setId(edge.getId().longValue());
        response.setOperationalStatus(edge.getOperationalStatus());
        response.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)edge.getSource().getId(), (long)edge.getId()));
        response.setReductionKeys(edge.getReductionKeys());
        response.setMapFunction(this.transform(edge.getMapFunction()));
        response.setWeight(edge.getWeight());
        response.setIpService(this.transform(edge.getIpService()));
        response.setFriendlyName(edge.getFriendlyName());
        return response;
    }

    private ChildEdgeResponseDTO transform(ChildEdge edge) {
        ChildEdgeResponseDTO response = new ChildEdgeResponseDTO();
        response.setId(edge.getId().longValue());
        response.setChildId(edge.getChild().getId());
        response.setOperationalStatus(edge.getOperationalStatus());
        response.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)edge.getSource().getId(), (long)edge.getId()));
        response.setReductionKeys(edge.getReductionKeys());
        response.setMapFunction(this.transform(edge.getMapFunction()));
        response.setWeight(edge.getWeight());
        return response;
    }

    private ReductionKeyEdgeResponseDTO transform(ReductionKeyEdge edge) {
        ReductionKeyEdgeResponseDTO response = new ReductionKeyEdgeResponseDTO();
        response.setId(edge.getId().longValue());
        response.setOperationalStatus(edge.getOperationalStatus());
        response.setReductionKey(edge.getReductionKey());
        response.setLocation(ResourceLocationFactory.createBusinessServiceEdgeLocation((long)edge.getSource().getId(), (long)edge.getId()));
        response.setReductionKeys(edge.getReductionKeys());
        response.setMapFunction(this.transform(edge.getMapFunction()));
        response.setWeight(edge.getWeight());
        response.setFriendlyName(edge.getFriendlyName());
        return response;
    }

    private MapFunction transform(MapFunctionDTO input) {
        return new FunctionsManager().getMapFunction(input);
    }

    private MapFunctionDTO transform(MapFunction input) {
        return new FunctionsManager().getMapFunctionDTO(input);
    }

    private ReduceFunctionDTO transform(ReductionFunction input) {
        return new FunctionsManager().getReduceFunctionDTO(input);
    }

    private ReductionFunction transform(ReduceFunctionDTO input) {
        return new FunctionsManager().getReduceFunction(input);
    }
}

