/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.bsm.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.opennms.web.rest.v2.bsm.model.JAXBMapAdapter;
import org.opennms.web.rest.v2.bsm.model.MapFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.ReduceFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.edge.AbstractEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ChildEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.IpServiceEdgeRequestDTO;
import org.opennms.web.rest.v2.bsm.model.edge.ReductionKeyEdgeRequestDTO;

@XmlRootElement(name="business-service")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BusinessServiceRequestDTO {
    @XmlElement(name="name")
    private String m_name;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=JAXBMapAdapter.class)
    private Map<String, String> m_attributes = Maps.newLinkedHashMap();
    @XmlElement(name="ip-service-edge")
    @XmlElementWrapper(name="ip-service-edges")
    private List<IpServiceEdgeRequestDTO> m_ipServices = Lists.newArrayList();
    @XmlElement(name="child-edge")
    @XmlElementWrapper(name="child-edges")
    private List<ChildEdgeRequestDTO> m_childServices = Lists.newArrayList();
    @XmlElement(name="reduction-key-edge")
    @XmlElementWrapper(name="reduction-key-edges")
    private List<ReductionKeyEdgeRequestDTO> reductionKeys = Lists.newArrayList();
    @XmlElement(name="reduce-function")
    private ReduceFunctionDTO reduceFunction;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    protected void addAttribute(String key, String value) {
        this.getAttributes().put(key, value);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.m_attributes = attributes;
    }

    public List<IpServiceEdgeRequestDTO> getIpServices() {
        return this.m_ipServices;
    }

    public void setIpServices(List<IpServiceEdgeRequestDTO> ipServices) {
        this.m_ipServices = ipServices;
    }

    public List<ChildEdgeRequestDTO> getChildServices() {
        return this.m_childServices;
    }

    public void setChildServices(List<ChildEdgeRequestDTO> childServices) {
        this.m_childServices = childServices;
    }

    public List<ReductionKeyEdgeRequestDTO> getReductionKeys() {
        return this.reductionKeys;
    }

    public void setReductionKeys(List<ReductionKeyEdgeRequestDTO> reductionKeys) {
        this.reductionKeys = reductionKeys;
    }

    public void setReduceFunction(ReduceFunctionDTO reduceFunction) {
        this.reduceFunction = reduceFunction;
    }

    public ReduceFunctionDTO getReduceFunction() {
        return this.reduceFunction;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessServiceRequestDTO other = (BusinessServiceRequestDTO)obj;
        return Objects.equals(this.m_name, other.m_name) && Objects.equals(this.m_attributes, other.m_attributes) && Objects.equals(this.reduceFunction, other.reduceFunction) && Objects.equals(this.m_ipServices, other.m_ipServices) && Objects.equals(this.m_childServices, other.m_childServices) && Objects.equals(this.reductionKeys, other.reductionKeys);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_attributes, this.m_ipServices, this.m_childServices, this.reductionKeys, this.reduceFunction);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("name", (Object)this.m_name).add("attributes", this.m_attributes).add("reduceFunction", (Object)this.reduceFunction).add("ipServices", this.m_ipServices).add("childServices", this.m_childServices).add("reductionKeys", this.reductionKeys).toString();
    }

    public void addChildService(long childId, MapFunctionDTO mapFunction, int weight) {
        ChildEdgeRequestDTO edge = new ChildEdgeRequestDTO();
        edge.setChildId(childId);
        edge.setMapFunction(mapFunction);
        edge.setWeight(weight);
        this.getChildServices().add(edge);
    }

    public void addReductionKey(String reductionKey, MapFunctionDTO mapFunction, int weight) {
        this.addReductionKey(reductionKey, mapFunction, weight, null);
    }

    public void addReductionKey(String reductionKey, MapFunctionDTO mapFunction, int weight, String friendlyName) {
        ReductionKeyEdgeRequestDTO edge = new ReductionKeyEdgeRequestDTO();
        edge.setReductionKey(reductionKey);
        edge.setMapFunction(mapFunction);
        edge.setWeight(weight);
        edge.setFriendlyName(friendlyName);
        this.getReductionKeys().add(edge);
    }

    public void addIpService(int ipServiceId, MapFunctionDTO mapFunction, int weight) {
        this.addIpService(ipServiceId, mapFunction, weight, null);
    }

    public void addIpService(int ipServiceId, MapFunctionDTO mapFunction, int weight, String friendlyName) {
        IpServiceEdgeRequestDTO edge = new IpServiceEdgeRequestDTO();
        edge.setIpServiceId(ipServiceId);
        edge.setMapFunction(mapFunction);
        edge.setWeight(weight);
        edge.setFriendlyName(friendlyName);
        this.getIpServices().add(edge);
    }

    @XmlTransient
    @JsonIgnore
    public List<AbstractEdgeRequestDTO> getEdges() {
        ArrayList<AbstractEdgeRequestDTO> edges = new ArrayList<AbstractEdgeRequestDTO>();
        edges.addAll(this.getChildServices());
        edges.addAll(this.getIpServices());
        edges.addAll(this.getReductionKeys());
        return edges;
    }
}

