/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.bsm.model.meta;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.web.rest.v2.bsm.model.MapFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.ReduceFunctionDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionMetaDTO;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionType;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class FunctionsManager {
    private List<Class<?>> getTypesAnnotatedWithFunction(String packageToScan) {
        Reflections reflections = new Reflections(packageToScan, new Scanner[0]);
        Set functions = reflections.getTypesAnnotatedWith(Function.class);
        return new ArrayList(functions);
    }

    public List<Class<?>> getMapFunctions() {
        return this.getTypesAnnotatedWithFunction("org.opennms.netmgt.bsm.service.model.functions.map");
    }

    public List<Class<?>> getReduceFunctions() {
        return this.getTypesAnnotatedWithFunction("org.opennms.netmgt.bsm.service.model.functions.reduce");
    }

    public FunctionMetaDTO getMapFunctionMetaData(String name) {
        Class<?> functionClass = this.findFunction(this.getMapFunctions(), name);
        if (functionClass != null) {
            return new FunctionMetaDTO(functionClass, FunctionType.MapFunction);
        }
        return null;
    }

    public FunctionMetaDTO getReduceFunctionMetaData(String name) {
        Class<?> functionClass = this.findFunction(this.getReduceFunctions(), name);
        if (functionClass != null) {
            return new FunctionMetaDTO(functionClass, FunctionType.ReduceFunction);
        }
        return null;
    }

    private Class<?> findFunction(List<Class<?>> functionMetaData, String name) {
        for (Class<?> eachClass : functionMetaData) {
            Function eachFunction = eachClass.getAnnotation(Function.class);
            if (!name.equals(eachFunction.name())) continue;
            return eachClass;
        }
        return null;
    }

    public MapFunctionDTO getMapFunctionDTO(MapFunction mapFunction) {
        Objects.requireNonNull(mapFunction);
        FunctionMetaDTO functionMeta = new FunctionMetaDTO(mapFunction.getClass(), FunctionType.MapFunction);
        MapFunctionDTO mapFunctionDTO = new MapFunctionDTO();
        mapFunctionDTO.setType(functionMeta.getName());
        mapFunctionDTO.setProperties(this.getFunctionProperties(mapFunction));
        return mapFunctionDTO;
    }

    public ReduceFunctionDTO getReduceFunctionDTO(ReductionFunction reduceFunction) {
        Objects.requireNonNull(reduceFunction);
        FunctionMetaDTO functionMeta = new FunctionMetaDTO(reduceFunction.getClass(), FunctionType.ReduceFunction);
        ReduceFunctionDTO reduceFunctionDTO = new ReduceFunctionDTO();
        reduceFunctionDTO.setType(functionMeta.getName());
        reduceFunctionDTO.setProperties(this.getFunctionProperties(reduceFunction));
        return reduceFunctionDTO;
    }

    public Map<String, String> getFunctionProperties(MapFunction mapFunction) {
        return this.getParametersAsProperties(mapFunction);
    }

    public Map<String, String> getFunctionProperties(ReductionFunction reduceFunction) {
        return this.getParametersAsProperties(reduceFunction);
    }

    private <T> Map<String, String> getParametersAsProperties(T function) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (Field eachField : function.getClass().getDeclaredFields()) {
            Parameter parameter = eachField.getAnnotation(Parameter.class);
            if (parameter == null) continue;
            try {
                eachField.setAccessible(true);
                Object value = eachField.get(function);
                propertiesMap.put(parameter.key(), String.valueOf(value));
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return propertiesMap;
    }

    public MapFunction getMapFunction(MapFunctionDTO input) {
        Objects.requireNonNull(input);
        Class<?> functionClass = this.findFunction(this.getMapFunctions(), input.getType());
        return (MapFunction)this.createFunctionInstance(functionClass, input.getProperties());
    }

    public <T> T createFunctionInstance(Class<? extends T> functionClass, Map<String, String> parameterMap) {
        T functionInstance;
        Objects.requireNonNull(functionClass);
        try {
            functionInstance = functionClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (Field field : functionClass.getDeclaredFields()) {
            String effectiveValueAsStr;
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null) continue;
            if (parameterMap.containsKey(parameter.key())) {
                effectiveValueAsStr = parameterMap.get(parameter.key());
            } else if (!parameter.required()) {
                effectiveValueAsStr = parameter.defaultValue();
            } else {
                throw new IllegalArgumentException("Parameter with key '" + parameter.key() + "' is required, but no value was given.");
            }
            Object effectiveValue = effectiveValueAsStr;
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                effectiveValue = Boolean.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                effectiveValue = Double.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                effectiveValue = Float.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                effectiveValue = Integer.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                effectiveValue = Long.valueOf(effectiveValueAsStr);
            } else if (field.getType().isEnum()) {
                ?[] enumConstants;
                for (Object eachEnumConstant : enumConstants = field.getType().getEnumConstants()) {
                    if (!effectiveValueAsStr.equalsIgnoreCase(String.valueOf(eachEnumConstant))) continue;
                    effectiveValue = eachEnumConstant;
                    break;
                }
            }
            try {
                field.setAccessible(true);
                field.set(functionInstance, effectiveValue);
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return functionInstance;
    }

    public ReductionFunction getReduceFunction(ReduceFunctionDTO input) {
        Objects.requireNonNull(input);
        Class<?> functionClass = this.findFunction(this.getReduceFunctions(), input.getType());
        return (ReductionFunction)this.createFunctionInstance(functionClass, input.getProperties());
    }
}

