/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.bsm.model.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.web.rest.v2.bsm.model.meta.FunctionType;
import org.opennms.web.rest.v2.bsm.model.meta.ParameterMetaDTO;

@XmlRootElement(name="function")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FunctionMetaDTO {
    @XmlAttribute
    private FunctionType type;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="description")
    private String description;
    @XmlElement(name="parameter")
    private List<ParameterMetaDTO> parameters;

    public FunctionMetaDTO() {
    }

    public FunctionMetaDTO(Class<?> function, FunctionType type) {
        Objects.requireNonNull(function, "function must not be null");
        Objects.requireNonNull(type, "type must not be null");
        Function functionAnnotation = function.getAnnotation(Function.class);
        Preconditions.checkState((functionAnnotation != null ? 1 : 0) != 0, (Object)"Functions must be annotated with @Function.");
        this.type = type;
        this.name = functionAnnotation.name();
        this.description = functionAnnotation.description();
        this.parameters = Lists.newArrayList();
        for (Field field : function.getDeclaredFields()) {
            Parameter filterParam = field.getAnnotation(Parameter.class);
            if (filterParam == null) continue;
            this.parameters.add(new ParameterMetaDTO(field, filterParam));
        }
    }

    public FunctionType getType() {
        return this.type;
    }

    public void setType(FunctionType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ParameterMetaDTO> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterMetaDTO> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionMetaDTO other = (FunctionMetaDTO)obj;
        boolean equals = Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.parameters, other.parameters);
        return equals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.type, this.parameters});
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("Name", (Object)this.name).add("Description", (Object)this.description).add("Type", (Object)this.type).add("Parameters", this.parameters).toString();
    }
}

