/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceDao;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.springframework.orm.hibernate3.HibernateCallback;

public class BusinessServiceDaoImpl
extends AbstractDaoHibernate<BusinessServiceEntity, Long>
implements BusinessServiceDao {
    public BusinessServiceDaoImpl() {
        super(BusinessServiceEntity.class);
    }

    public Set<BusinessServiceEntity> findParents(BusinessServiceEntity child) {
        final long childId = Objects.requireNonNull(child).getId();
        Set parents = (Set)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Set<BusinessServiceEntity>>(){

            public Set<BusinessServiceEntity> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select edge from BusinessServiceEdgeEntity edge where type(edge) = BusinessServiceChildEdgeEntity and edge.child.id = :childId");
                query.setParameter("childId", (Object)childId);
                List list = query.list();
                return list.stream().map(e -> e.getBusinessService()).collect(Collectors.toSet());
            }
        });
        return parents;
    }

    public List<BusinessServiceEntity> findMatching(org.opennms.core.criteria.Criteria criteria) {
        HibernateCallback callback = session -> {
            if (criteria.getLimit() != null || criteria.getOffset() != null) {
                Criteria idCriteria = this.m_criteriaConverter.convert(criteria, session);
                idCriteria.setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.property((String)"id")).add((Projection)Projections.property((String)"name"))));
                List idList = idCriteria.list();
                if (!idList.isEmpty()) {
                    Criteria entityCriteria = session.createCriteria(criteria.getCriteriaClass());
                    entityCriteria.add(Restrictions.in((String)"id", (Collection)idList.stream().map(e -> e[0]).collect(Collectors.toList())));
                    entityCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                    return entityCriteria.list();
                }
                return Collections.emptyList();
            }
            Criteria hibernateCriteria = this.m_criteriaConverter.convert(criteria, session);
            hibernateCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            return hibernateCriteria.list();
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }
}

