/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Size;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;

@Entity
@Table(name="bsm_service_reductionkeys", uniqueConstraints={@UniqueConstraint(columnNames={"id", "reductionkey"})})
@PrimaryKeyJoinColumn(name="id")
@DiscriminatorValue(value="reductionkeys")
public class SingleReductionKeyEdgeEntity
extends BusinessServiceEdgeEntity {
    private String reductionKey;
    private String m_friendlyName;

    public void setReductionKey(String reductionKey) {
        this.reductionKey = reductionKey;
    }

    @Column(name="reductionkey", nullable=false)
    public String getReductionKey() {
        return this.reductionKey;
    }

    @Override
    @Transient
    public Set<String> getReductionKeys() {
        return Sets.newHashSet((Object[])new String[]{this.reductionKey});
    }

    @Column(name="friendlyname", nullable=true)
    @Size(min=0, max=30)
    public String getFriendlyName() {
        return this.m_friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.m_friendlyName = friendlyName;
    }

    @Override
    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("reductionKey", (Object)this.reductionKey).toString();
    }

    @Override
    public boolean equalsDefinition(BusinessServiceEdgeEntity other) {
        boolean equalsSuper = super.equalsDefinition(other);
        if (equalsSuper) {
            return Objects.equals(this.reductionKey, ((SingleReductionKeyEdgeEntity)other).reductionKey) && Objects.equals(this.m_friendlyName, ((SingleReductionKeyEdgeEntity)other).m_friendlyName);
        }
        return false;
    }

    @Override
    public <T> T accept(EdgeEntityVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

