/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class ReductionKeyHelper {
    public static final String DEFAULT_DISTRIBUTED_POLLER_NAME = "";

    public static Set<String> getReductionKeys(OnmsMonitoredService monitoredService) {
        Objects.requireNonNull(monitoredService);
        HashSet<String> reductionKeys = new HashSet<String>();
        reductionKeys.add(ReductionKeyHelper.getNodeLostServiceReductionKey(monitoredService));
        reductionKeys.add(ReductionKeyHelper.getNodeDownReductionKey(monitoredService));
        reductionKeys.add(ReductionKeyHelper.getInterfaceDownReductionKey(monitoredService));
        return reductionKeys;
    }

    public static String getNodeDownReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%d", "uei.opennms.org/nodes/nodeDown", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId());
    }

    public static String getNodeLostServiceReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%d:%s:%s", "uei.opennms.org/nodes/nodeLostService", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId(), InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress()), monitoredService.getServiceName());
    }

    public static String getInterfaceDownReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%s:%s", "uei.opennms.org/nodes/interfaceDown", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId(), InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress()));
    }
}

