/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.daemon;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateChangeHandler;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.internal.AlarmWrapperImpl;
import org.opennms.netmgt.bsm.service.internal.SeverityMapper;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphAlgorithms;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@EventListener(name="Bsmd", logPrefix="bsmd")
public class Bsmd
implements SpringServiceDaemon,
BusinessServiceStateChangeHandler,
AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(Bsmd.class);
    protected static final long DEFAULT_POLL_INTERVAL = 30L;
    protected static final String POLL_INTERVAL_KEY = "org.opennms.features.bsm.pollInterval";
    public static final String NAME = "Bsmd";
    public static final long RELOAD_DELAY = 1000L;
    @Autowired
    @Qualifier(value="eventIpcManager")
    private EventIpcManager m_eventIpcManager;
    @Autowired
    private EventConfDao m_eventConfDao;
    @Autowired
    private TransactionTemplate m_template;
    @Autowired
    private BusinessServiceStateMachine m_stateMachine;
    @Autowired
    private BusinessServiceManager m_manager;
    private boolean m_verifyReductionKeys = true;
    private ScheduledExecutorService daemonReloadScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("bsm-daemon-reload-%d").build());
    private volatile long reloadConfigurationAt;

    public Bsmd() {
        this.daemonReloadScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (Bsmd.this.reloadConfigurationAt > 0L && Bsmd.this.reloadConfigurationAt < System.currentTimeMillis()) {
                    Bsmd.this.reloadConfigurationAt = 0L;
                    EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "bsmd");
                    eventBuilder.addParam("daemonName", "bsmd");
                    Bsmd.this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.reloadConfigurationAt = 0L;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.m_stateMachine, "stateMachine cannot be null");
        LOG.info("Initializing bsmd...");
        this.m_stateMachine.addHandler((BusinessServiceStateChangeHandler)this, null);
    }

    public void start() throws Exception {
        Objects.requireNonNull(this.m_manager, "businessServiceDao cannot be null");
        Objects.requireNonNull(this.m_eventIpcManager, "eventIpcManager cannot be null");
        Objects.requireNonNull(this.m_eventConfDao, "eventConfDao cannot be null");
        this.handleConfigurationChanged();
    }

    public void handleAlarmSnapshot(List<OnmsAlarm> alarms) {
        List wrappedAlarms = alarms.stream().map(AlarmWrapperImpl::new).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling {} alarms.", (Object)alarms.size());
            LOG.trace("Handling alarms: {}", alarms);
        }
        this.m_stateMachine.handleAllAlarms(wrappedAlarms);
    }

    public void preHandleAlarmSnapshot() {
    }

    public void postHandleAlarmSnapshot() {
    }

    public void handleNewOrUpdatedAlarm(OnmsAlarm alarm) {
        AlarmWrapperImpl alarmWrapper = new AlarmWrapperImpl(alarm);
        LOG.debug("Handling alarm with id: {}, reduction key: {} and severity: {} and status: {}", new Object[]{alarm.getId(), alarm.getReductionKey(), alarm.getSeverity(), alarmWrapper.getStatus()});
        this.m_stateMachine.handleNewOrUpdatedAlarm((AlarmWrapper)alarmWrapper);
    }

    public void handleDeletedAlarm(int alarmId, final String reductionKey) {
        LOG.debug("Handling delete for alarm with id: {} and reduction key: {}", (Object)alarmId, (Object)reductionKey);
        this.m_stateMachine.handleNewOrUpdatedAlarm(new AlarmWrapper(){

            public String getReductionKey() {
                return reductionKey;
            }

            public Status getStatus() {
                return Status.INDETERMINATE;
            }
        });
    }

    private Collection<BusinessService> searchPredecessors(GraphVertex leaf) {
        HashSet<BusinessService> businessServices = new HashSet<BusinessService>();
        Collection predecessors = this.m_stateMachine.getGraph().getPredecessors((Object)leaf);
        for (GraphVertex graphVertex : predecessors) {
            if (graphVertex.getBusinessService() != null) {
                businessServices.add(graphVertex.getBusinessService());
                continue;
            }
            businessServices.addAll(this.searchPredecessors(graphVertex));
        }
        return businessServices;
    }

    @EventHandler(ueis={"uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/interfaceDeleted", "uei.opennms.org/nodes/nodeDeleted", "uei.opennms.org/internal/applicationDeleted"})
    public void serviceInterfaceOrNodeDeleted(IEvent e) {
        Set reductionKeys = this.m_stateMachine.getGraph().getReductionKeys();
        if ("uei.opennms.org/nodes/nodeDeleted".equals(e.getUei()) && reductionKeys.contains(String.format("uei.opennms.org/nodes/nodeDown::%d", e.getNodeid())) || "uei.opennms.org/nodes/interfaceDeleted".equals(e.getUei()) && reductionKeys.contains(String.format("uei.opennms.org/nodes/interfaceDown::%d:%s", e.getNodeid(), e.getInterface())) || "uei.opennms.org/nodes/serviceDeleted".equals(e.getUei()) && reductionKeys.contains(String.format("uei.opennms.org/nodes/nodeLostService::%d:%s:%s", e.getNodeid(), e.getInterface(), e.getService())) || "uei.opennms.org/internal/applicationDeleted".equals(e.getUei()) && this.m_stateMachine.getGraph().getVertexByApplicationId(Integer.valueOf(Integer.parseInt(e.getParm("applicationId").getValue().getContent()))) != null) {
            GraphVertex vertex;
            HashSet<BusinessService> affectedBusinessServices = new HashSet<BusinessService>();
            String cause = "an associated entity";
            if ("uei.opennms.org/internal/applicationDeleted".equals(e.getUei())) {
                vertex = this.m_stateMachine.getGraph().getVertexByApplicationId(Integer.valueOf(Integer.parseInt(e.getParm("applicationId").getValue().getContent())));
                affectedBusinessServices.addAll(this.searchPredecessors(vertex));
                cause = "application '" + e.getParm("applicationName").getValue().getContent() + "'";
            }
            if ("uei.opennms.org/nodes/nodeDeleted".equals(e.getUei())) {
                vertex = this.m_stateMachine.getGraph().getVertexByReductionKey(String.format("uei.opennms.org/nodes/nodeDown::%d", e.getNodeid()));
                affectedBusinessServices.addAll(this.searchPredecessors(vertex));
                cause = "node '" + e.getNodeid() + "'";
            }
            if ("uei.opennms.org/nodes/interfaceDeleted".equals(e.getUei())) {
                vertex = this.m_stateMachine.getGraph().getVertexByReductionKey(String.format("uei.opennms.org/nodes/interfaceDown::%d:%s", e.getNodeid(), e.getInterface()));
                affectedBusinessServices.addAll(this.searchPredecessors(vertex));
                cause = "interface '" + e.getNodeid() + "/" + e.getInterface() + "'";
            }
            if ("uei.opennms.org/nodes/serviceDeleted".equals(e.getUei())) {
                vertex = this.m_stateMachine.getGraph().getVertexByReductionKey(String.format("uei.opennms.org/nodes/nodeLostService::%d:%s:%s", e.getNodeid(), e.getInterface(), e.getService()));
                affectedBusinessServices.addAll(this.searchPredecessors(vertex));
                cause = "service '" + e.getNodeid() + "/" + e.getInterface() + "/" + e.getService() + "'";
            }
            this.reloadConfigurationAt = System.currentTimeMillis() + 1000L;
            for (BusinessService businessService : affectedBusinessServices) {
                EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/bsm/graphInvalidated", "bsmd");
                eventBuilder.addParam("businessServiceId", businessService.getId().longValue());
                eventBuilder.addParam("businessServiceName", businessService.getName());
                eventBuilder.addParam("cause", cause);
                org.opennms.netmgt.xml.event.Event event = eventBuilder.getEvent();
                try {
                    this.m_eventIpcManager.send(event);
                }
                catch (EventProxyException ex) {
                    LOG.error("Cannot send event " + event.getUei(), (Throwable)ex);
                }
            }
        }
    }

    private void handleConfigurationChanged() {
        if (this.m_verifyReductionKeys) {
            this.verifyReductionKey("uei.opennms.org/nodes/nodeLostService", "%uei%:%dpname%:%nodeid%:%interface%:%service%");
            this.verifyReductionKey("uei.opennms.org/nodes/nodeDown", "%uei%:%dpname%:%nodeid%");
            this.verifyReductionKey("uei.opennms.org/nodes/interfaceDown", "%uei%:%dpname%:%nodeid%:%interface%");
        }
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List businessServices = Bsmd.this.m_manager.getAllBusinessServices();
                LOG.debug("Adding {} business services to the state machine.", (Object)businessServices.size());
                Bsmd.this.m_stateMachine.setBusinessServices(businessServices);
            }
        });
    }

    private void verifyReductionKey(String uei, String expectedReductionKey) {
        List eventsForUei = this.m_eventConfDao.getEvents(uei);
        if (eventsForUei == null) {
            LOG.warn("Could not find an event with uei '{}'.", (Object)uei);
            return;
        }
        if (eventsForUei.size() != 1) {
            LOG.warn("Could not find a unique event definition for uei '{}'.", (Object)uei);
            return;
        }
        if (((Event)eventsForUei.get(0)).getAlarmData() == null) {
            LOG.warn("Could not find alarm data for event with uei '{}'.", (Object)uei);
            return;
        }
        AlarmData alarmData = ((Event)eventsForUei.get(0)).getAlarmData();
        if (!expectedReductionKey.equals(alarmData.getReductionKey())) {
            LOG.warn("Expected reduction key '{}' for uei '{}' but found '{}'.", new Object[]{expectedReductionKey, uei, alarmData.getReductionKey()});
        }
    }

    public void handleBusinessServiceStateChanged(BusinessServiceGraph graph, BusinessService businessService, Status newStatus, Status prevStatus) {
        OnmsSeverity newSeverity = SeverityMapper.toSeverity(newStatus);
        OnmsSeverity prevSeverity = SeverityMapper.toSeverity(prevStatus);
        EventBuilder ebldr = new EventBuilder("uei.opennms.org/bsm/serviceOperationalStatusChanged", NAME);
        Bsmd.addBusinessServicesAttributesAsEventParms(businessService, ebldr);
        ebldr.addParam("businessServiceId", businessService.getId().longValue());
        ebldr.addParam("businessServiceName", businessService.getName());
        ebldr.addParam("prevSeverityId", prevSeverity.getId());
        ebldr.addParam("prevSeverityLabel", prevSeverity.getLabel());
        ebldr.addParam("newSeverityId", newSeverity.getId());
        ebldr.addParam("newSeverityLabel", newSeverity.getLabel());
        this.m_eventIpcManager.sendNow(ebldr.getEvent());
        if (newSeverity.isGreaterThan(OnmsSeverity.NORMAL)) {
            ebldr = new EventBuilder("uei.opennms.org/bsm/serviceProblem", NAME);
            Bsmd.addBusinessServicesAttributesAsEventParms(businessService, ebldr);
            ebldr.addParam("businessServiceId", businessService.getId().longValue());
            ebldr.addParam("businessServiceName", businessService.getName());
            ebldr.setSeverity(newSeverity.toString());
            List vertices = GraphAlgorithms.calculateRootCause((BusinessServiceGraph)graph, (GraphVertex)graph.getVertexByBusinessServiceId(businessService.getId()));
            String rootCause = vertices.stream().map(v -> {
                if (v.getBusinessService() != null) {
                    return "business service '" + v.getBusinessService().getName() + "'";
                }
                if (v.getIpService() != null) {
                    return "IP service '" + v.getIpService().getNodeLabel() + "/" + v.getIpService().getIpAddress() + "/" + v.getIpService().getServiceName() + "'";
                }
                if (v.getApplication() != null) {
                    return "application '" + v.getApplication().getApplicationName() + "'";
                }
                return "reduction key '" + v.getReductionKey() + "'";
            }).collect(Collectors.joining(", "));
            ebldr.addParam("rootCause", rootCause);
        } else {
            ebldr = new EventBuilder("uei.opennms.org/bsm/serviceProblemResolved", NAME);
            Bsmd.addBusinessServicesAttributesAsEventParms(businessService, ebldr);
            ebldr.addParam("businessServiceId", businessService.getId().longValue());
            ebldr.addParam("businessServiceName", businessService.getName());
        }
        this.m_eventIpcManager.sendNow(ebldr.getEvent());
    }

    private static void addBusinessServicesAttributesAsEventParms(BusinessService businessService, EventBuilder ebldr) {
        businessService.getAttributes().entrySet().stream().forEach(attr -> ebldr.addParam((String)attr.getKey(), (String)attr.getValue()));
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(IEvent e) {
        DaemonTools.handleReloadEvent((IEvent)e, (String)NAME, event -> this.handleConfigurationChanged());
    }

    public void destroy() {
        LOG.info("Stopping bsmd...");
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.m_template;
    }

    public void setVerifyReductionKeys(boolean verify) {
        this.m_verifyReductionKeys = verify;
    }

    public boolean getVerifyReductionKeys() {
        return this.m_verifyReductionKeys;
    }

    public void setBusinessServiceStateMachine(BusinessServiceStateMachine stateMachine) {
        this.m_stateMachine = stateMachine;
    }

    public BusinessServiceStateMachine getBusinessServiceStateMachine() {
        return this.m_stateMachine;
    }
}

